/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.spring.metadata;

import java.util.List;

import javax.annotation.Nonnull;

import net.shibboleth.shared.primitive.StringSupport;
import net.shibboleth.shared.spring.util.SpringSupport;
import net.shibboleth.shared.xml.ElementSupport;

import org.opensaml.saml.metadata.resolver.ChainingMetadataResolver;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

/**
 * Parser for &lt;ChainingMetadataProvider&gt;.
 */
public class ChainingMetadataProviderParser extends AbstractMetadataProviderParser {

    /** {@inheritDoc} */
    @Override
    @Nonnull protected Class<ChainingMetadataResolver> getNativeBeanClass(@Nonnull final Element element) {
        return ChainingMetadataResolver.class;
    }

    /** {@inheritDoc} */
    @Override protected void doNativeParse(@Nonnull final Element element, @Nonnull final ParserContext parserContext, 
            @Nonnull final BeanDefinitionBuilder builder) {
        super.doNativeParse(element, parserContext, builder);

        final List<Element> childProviders =
                ElementSupport.getChildElements(element, MetadataNamespaceHandler.METADATA_ELEMENT_NAME);

        builder.addPropertyValue("resolvers",
                SpringSupport.parseCustomElements(childProviders, parserContext, builder));
        
        if (element.hasAttributeNS(null, "detectDuplicateEntityIDs")) {
            builder.addPropertyValue("detectDuplicateEntityIDs",
                    StringSupport.trimOrNull(element.getAttributeNS(null, "detectDuplicateEntityIDs")));
        }
    }

}