/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.spring.metadata;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;

import net.shibboleth.shared.spring.custom.BaseSpringNamespaceHandler;
import net.shibboleth.spring.metadata.filter.AlgorithmFilterParser;
import net.shibboleth.spring.metadata.filter.ByReferenceParser;
import net.shibboleth.spring.metadata.filter.EntitiesDescriptorNameParser;
import net.shibboleth.spring.metadata.filter.EntityAttributesFilterParser;
import net.shibboleth.spring.metadata.filter.EntityRoleFilterParser;
import net.shibboleth.spring.metadata.filter.KeyAuthorityParser;
import net.shibboleth.spring.metadata.filter.NameIDFormatFilterParser;
import net.shibboleth.spring.metadata.filter.NodeProcessingParser;
import net.shibboleth.spring.metadata.filter.PredicateFilterParser;
import net.shibboleth.spring.metadata.filter.RequiredValidUntilParser;
import net.shibboleth.spring.metadata.filter.SchemaValidationParser;
import net.shibboleth.spring.metadata.filter.SignatureValidationParser;

/** Namespace handler for <code>urn:mace:shibboleth:2.0:metadata</code>. */
public class MetadataNamespaceHandler extends BaseSpringNamespaceHandler {

    /** Metadata provider element name. */
    @Nonnull public static final QName METADATA_ELEMENT_NAME =
            new QName(AbstractMetadataProviderParser.METADATA_NAMESPACE, "MetadataProvider");

    /** Metadata node processor Element name. */
    @Nonnull public static final QName METADATA_NODE_PROC_ELEMENT_NAME =
            new QName(AbstractMetadataProviderParser.METADATA_NAMESPACE, "MetadataNodeProcessor");

    /** {@inheritDoc} */
    @Override public void init() {
        // Profile Configuration
        registerBeanDefinitionParser(AbstractMetadataProviderParser.CHAINING_PROVIDER_ELEMENT_NAME,
                new ChainingMetadataProviderParser());
        registerBeanDefinitionParser(InlineMetadataProviderParser.ELEMENT_NAME, new InlineMetadataProviderParser());
        registerBeanDefinitionParser(FilesystemMetadataProviderParser.ELEMENT_NAME,
                new FilesystemMetadataProviderParser());
        registerBeanDefinitionParser(FileBackedHTTPMetadataProviderParser.ELEMENT_NAME,
                new FileBackedHTTPMetadataProviderParser());
        registerBeanDefinitionParser(ResourceBackedMetadataProviderParser.ELEMENT_NAME,
                new ResourceBackedMetadataProviderParser());
        registerBeanDefinitionParser(DynamicHTTPMetadataProviderParser.ELEMENT_NAME,
                new DynamicHTTPMetadataProviderParser());
        registerBeanDefinitionParser(LocalDynamicMetadataProviderParser.ELEMENT_NAME,
                new LocalDynamicMetadataProviderParser());

        // Filters
        registerBeanDefinitionParser(PredicateFilterParser.TYPE_NAME, new PredicateFilterParser());
        registerBeanDefinitionParser(RequiredValidUntilParser.TYPE_NAME, new RequiredValidUntilParser());
        registerBeanDefinitionParser(AlgorithmFilterParser.TYPE_NAME, new AlgorithmFilterParser());
        registerBeanDefinitionParser(EntityAttributesFilterParser.TYPE_NAME, new EntityAttributesFilterParser());
        registerBeanDefinitionParser(NameIDFormatFilterParser.TYPE_NAME, new NameIDFormatFilterParser());
        registerBeanDefinitionParser(EntityRoleFilterParser.TYPE_NAME, new EntityRoleFilterParser());
        registerBeanDefinitionParser(SchemaValidationParser.TYPE_NAME, new SchemaValidationParser());
        registerBeanDefinitionParser(SignatureValidationParser.TYPE_NAME, new SignatureValidationParser());
        registerBeanDefinitionParser(NodeProcessingParser.TYPE_NAME, new NodeProcessingParser());
        registerBeanDefinitionParser(ByReferenceParser.TYPE_NAME, new ByReferenceParser());

        // Node Processors
        registerBeanDefinitionParser(EntitiesDescriptorNameParser.TYPE_NAME, new EntitiesDescriptorNameParser());
        registerBeanDefinitionParser(KeyAuthorityParser.TYPE_NAME, new KeyAuthorityParser());
    }

}