/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.spring.security.credential;

import javax.annotation.Nonnull;
import javax.xml.namespace.QName;

import net.shibboleth.spring.security.SecurityNamespaceHandler;

import org.opensaml.spring.credential.BasicInlineCredentialFactoryBean;
import org.w3c.dom.Element;

/**
 * Parser for BasicInline Credentials.
 */
public class BasicInlineCredentialParser extends AbstractBasicCredentialParser {

    /** Element Name.*/
    @Nonnull public static final QName TYPE_NAME =
            new QName(SecurityNamespaceHandler.SECURITY_NAMESPACE, "BasicInline");

    /** {@inheritDoc} */
    @Override
    @Nonnull protected Class<?> getBeanClass(@Nonnull final Element element) {
        return BasicInlineCredentialFactoryBean.class;
    }
}
