/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.spring.security.trust;

import javax.annotation.Nonnull;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.spring.custom.AbstractCustomBeanDefinitionParser;
import net.shibboleth.shared.xml.AttributeSupport;

/**
 * Basis of all parsers for &lt;security:TrustEngine&gt;.
 */
public abstract class AbstractTrustEngineParser extends AbstractCustomBeanDefinitionParser {

    /** {@inheritDoc} */
    @Override
    @Nonnull @NotEmpty protected String resolveId(@Nonnull final Element element,
            @Nonnull final AbstractBeanDefinition definition, @Nonnull final ParserContext parserContext) {
        return AttributeSupport.ensureAttributeValue(element, null, "id");
    }

    @Override protected void doParse(@Nonnull final Element element, @Nonnull final ParserContext parserContext,
            @Nonnull final BeanDefinitionBuilder builder) {
        super.doParse(element, parserContext, builder);
        builder.setLazyInit(true);
    }

}