/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.spring.testing;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeTest;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.spring.util.ApplicationContextBuilder;
import net.shibboleth.shared.spring.util.SpringSupport;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mock.env.MockPropertySource;
import org.testng.annotations.AfterSuite;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;

public class AbstractFailFastTest
extends OpenSAMLInitBaseTestCase {
    @NonnullBeforeTest
    private String workspaceDirName;
    @NonnullBeforeTest
    static List<GenericApplicationContext> contexts;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerContext(@Nonnull GenericApplicationContext context) {
        List<GenericApplicationContext> list = contexts;
        synchronized (list) {
            contexts.add(context);
        }
    }

    @Nonnull
    @NotEmpty
    protected String getPath() {
        return "/net/shibboleth/spring/failfast/";
    }

    @NonnullBeforeTest
    protected String getWorkspaceDirName() {
        return this.workspaceDirName;
    }

    @BeforeSuite
    public void beforeSuite() throws IOException {
        contexts = new ArrayList<GenericApplicationContext>();
    }

    @BeforeClass
    public void beforeClass() throws IOException {
        ClassPathResource resource = new ClassPathResource(this.getPath());
        this.workspaceDirName = resource.getFile().getAbsolutePath() + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AfterSuite
    public void afterSuite() {
        Iterator<GenericApplicationContext> contextIterator = contexts.iterator();
        while (contextIterator.hasNext()) {
            GenericApplicationContext context;
            List<GenericApplicationContext> list = contexts;
            synchronized (list) {
                context = contextIterator.next();
            }
            context.close();
        }
    }

    @Nonnull
    protected ApplicationContext getApplicationContext(@Nonnull String contextName, @Nullable MockPropertySource propSource, String ... files) throws IOException {
        Object[] resources = new Resource[files.length];
        for (int i = 0; i < files.length; ++i) {
            resources[i] = new ClassPathResource(this.getPath() + files[i]);
        }
        ApplicationContextBuilder builder = new ApplicationContextBuilder();
        builder.setName(contextName);
        if (propSource == null) {
            builder.setPropertySources(CollectionSupport.emptyList());
        } else {
            builder.setPropertySources(CollectionSupport.singletonList((Object)propSource));
        }
        builder.setServiceConfigurations((Collection)CollectionSupport.arrayAsList((Object[])resources));
        GenericApplicationContext context = builder.build();
        this.registerContext(context);
        return context;
    }

    @Nonnull
    protected ApplicationContext getApplicationContext(@Nonnull String contextName, String ... files) throws IOException {
        return this.getApplicationContext(contextName, (MockPropertySource)null, files);
    }

    @Nullable
    protected Object getBean(@Nullable MockPropertySource propSource, String ... files) throws IOException {
        return this.getBean(propSource, true, files);
    }

    @Nullable
    protected Object getBean(@Nullable MockPropertySource propSource, @Nullable Boolean failFast, String ... files) throws IOException {
        Class<ReloadableService> claz = ReloadableService.class;
        if (propSource != null) {
            if (null == failFast) {
                propSource.setProperty("failFast", (Object)"");
            } else if (failFast.booleanValue()) {
                propSource.setProperty("failFast", (Object)"true");
            } else {
                propSource.setProperty("failFast", (Object)"false");
            }
        }
        try {
            ApplicationContext context = this.getApplicationContext(claz.getCanonicalName(), propSource, files);
            return SpringSupport.getBean((BeanFactory)context, claz);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(AbstractFailFastTest.class).debug("GetAppContext failed", (Throwable)e);
            return null;
        }
    }

    @Nullable
    protected Object getBean(String ... files) throws IOException {
        return this.getBean((MockPropertySource)null, files);
    }

    @Nonnull
    protected MockPropertySource propertySource(@Nonnull String name, @Nonnull String value) {
        MockPropertySource propSource = new MockPropertySource("localProperties");
        propSource.setProperty(name, (Object)value);
        return propSource;
    }

    @Nonnull
    protected MockPropertySource propertySource(@Nonnull Collection<MockProperty> values) {
        MockPropertySource propSource = new MockPropertySource("localProperties");
        for (MockProperty property : values) {
            propSource.setProperty(property.name(), (Object)property.value());
        }
        return propSource;
    }

    @Nonnull
    @NotEmpty
    protected String makePath(String filePart) {
        return this.getWorkspaceDirName() + filePart;
    }

    @Nonnull
    @NotEmpty
    protected String makeTempPath(String filePart) {
        return this.getWorkspaceDirName() + filePart;
    }

    public record MockProperty(@Nonnull String name, @Nonnull String value) {
        @Nonnull
        private final String name;
        @Nonnull
        private final String value;

        public MockProperty(@Nonnull String name, @Nonnull String value) {
            this.name = (String)Constraint.isNotNull((Object)name, (String)"Name cannot be null");
            this.value = (String)Constraint.isNotNull((Object)value, (String)"Value cannot be null");
        }

        @Nonnull
        public String name() {
            assert (this.name != null);
            return this.name;
        }

        @Nonnull
        public String value() {
            assert (this.value != null);
            return this.value;
        }
    }
}

