/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.httpclient.resource;

import java.io.IOException;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.httpclient.HttpClientBuilder;
import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import net.shibboleth.shared.spring.custom.SchemaTypeAwareXMLBeanDefinitionReader;
import net.shibboleth.shared.spring.httpclient.resource.HTTPResource;
import net.shibboleth.shared.spring.httpclient.resource.RepositorySupport;
import net.shibboleth.shared.spring.httpclient.resource.ResourceTestHelper;
import net.shibboleth.shared.spring.resource.ConditionalResource;
import net.shibboleth.shared.spring.resource.ConditionalResourceResolver;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class ConditionalResourceTest {
    private final String documentPath = "/net/shibboleth/shared/spring/httpclient/resource/document.xml";
    private final String existsURL = RepositorySupport.buildHTTPResourceURL("java-shib-shared", "shib-networking-spring/src/test/resources/net/shibboleth/shared/spring/httpclient/resource/document.xml", false);
    private final String nonExistsURL = RepositorySupport.buildHTTPResourceURL("java-shib-shared", "trunk/src/test/resources/data/document.xml", false);
    private HttpClient client;

    @BeforeClass
    public void setupClient() throws Exception {
        this.client = new HttpClientBuilder().buildClient();
    }

    @Test
    public void existsTest() throws IOException, ComponentInitializationException {
        HTTPResource existsHTTPResource = new HTTPResource(this.client, this.existsURL);
        HTTPResource notExistsHTTPResource = new HTTPResource(this.client, this.nonExistsURL);
        ConditionalResource existsResource = new ConditionalResource((Resource)existsHTTPResource);
        ConditionalResource notExistsResource = new ConditionalResource((Resource)notExistsHTTPResource);
        existsResource.setId("test");
        existsResource.initialize();
        notExistsResource.setId("test");
        notExistsResource.initialize();
        Assert.assertTrue((boolean)existsHTTPResource.exists());
        Assert.assertFalse((boolean)notExistsHTTPResource.exists());
        Assert.assertTrue((boolean)existsResource.exists());
        Assert.assertTrue((boolean)notExistsResource.exists());
    }

    @Test
    public void contextHandlerFailBeforeTest() throws IOException, ComponentInitializationException {
        HTTPResource existsHTTPResource = new HTTPResource(this.client, this.existsURL);
        existsHTTPResource.setHttpClientContextHandler(new HttpClientContextHandler(){

            public void invokeBefore(HttpClientContext context, ClassicHttpRequest request) throws IOException {
                throw new IOException("Fail");
            }

            public void invokeAfter(HttpClientContext context, ClassicHttpRequest request) throws IOException {
            }
        });
        ConditionalResource existsResource = new ConditionalResource((Resource)existsHTTPResource);
        existsResource.setId("test");
        existsResource.initialize();
        Assert.assertTrue((boolean)existsResource.exists());
    }

    @Test
    public void contextHandlerFailAfterTest() throws IOException, ComponentInitializationException {
        HTTPResource existsHTTPResource = new HTTPResource(this.client, this.existsURL);
        existsHTTPResource.setHttpClientContextHandler(new HttpClientContextHandler(){

            public void invokeBefore(HttpClientContext context, ClassicHttpRequest request) throws IOException {
            }

            public void invokeAfter(HttpClientContext context, ClassicHttpRequest request) throws IOException {
                throw new IOException("Fail");
            }
        });
        ConditionalResource existsResource = new ConditionalResource((Resource)existsHTTPResource);
        existsResource.setId("test");
        existsResource.initialize();
        Assert.assertTrue((boolean)existsResource.exists());
    }

    @Test
    public void testCompare() throws IOException, ComponentInitializationException {
        HTTPResource existsHTTPResource = new HTTPResource(this.client, this.existsURL);
        ConditionalResource existsResource = new ConditionalResource((Resource)existsHTTPResource);
        existsResource.setId("test");
        existsResource.initialize();
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)existsResource, (Resource)new ClassPathResource("/net/shibboleth/shared/spring/httpclient/resource/document.xml")));
    }

    @Test
    public void testBeanExists() throws ComponentInitializationException {
        ClassPathResource existsCPResource = new ClassPathResource("net/shibboleth/shared/spring/httpclient/resource/conditional.xml");
        ConditionalResource existsResource = new ConditionalResource((Resource)existsCPResource);
        existsResource.setId("test");
        existsResource.initialize();
        GenericApplicationContext parentContext = new GenericApplicationContext();
        parentContext.refresh();
        GenericApplicationContext context = new GenericApplicationContext((ApplicationContext)parentContext);
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.setValidationMode(3);
        beanDefinitionReader.loadBeanDefinitions((Resource)existsResource);
        context.refresh();
        Assert.assertEquals((Object)context.getBean("testBean"), (Object)"foo");
    }

    @Test
    public void testBeanMissing() throws ComponentInitializationException {
        ClassPathResource missingCPResource = new ClassPathResource("net/shibboleth/shared/spring/httpclient/resource/missing.xml");
        ConditionalResource missingResource = new ConditionalResource((Resource)missingCPResource);
        missingResource.setId("test");
        missingResource.initialize();
        GenericApplicationContext parentContext = new GenericApplicationContext();
        parentContext.refresh();
        GenericApplicationContext context = new GenericApplicationContext((ApplicationContext)parentContext);
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.setValidationMode(3);
        beanDefinitionReader.loadBeanDefinitions((Resource)missingResource);
        context.refresh();
        Assert.assertFalse((boolean)context.containsBean("testBean"));
    }

    @Test
    public void testImport() {
        ClassPathResource resource = new ClassPathResource("net/shibboleth/shared/spring/httpclient/resource/conditional-import.xml");
        GenericApplicationContext parentContext = new GenericApplicationContext();
        parentContext.refresh();
        GenericApplicationContext context = new GenericApplicationContext((ApplicationContext)parentContext);
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        context.addProtocolResolver((ProtocolResolver)new ConditionalResourceResolver());
        beanDefinitionReader.setValidationMode(3);
        beanDefinitionReader.loadBeanDefinitions((Resource)resource);
        context.refresh();
        Assert.assertEquals((Object)context.getBean("testBean"), (Object)"foo");
    }
}

