/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.httpclient.resource;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.httpclient.HttpClientBuilder;
import net.shibboleth.shared.spring.httpclient.resource.FileBackedHTTPResource;
import net.shibboleth.shared.spring.httpclient.resource.RepositorySupport;
import net.shibboleth.shared.spring.httpclient.resource.ResourceTestHelper;
import net.shibboleth.shared.spring.util.ApplicationContextBuilder;
import org.apache.hc.client5.http.classic.HttpClient;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.mock.env.MockPropertySource;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class FileBackedHTTPResourceTest {
    private final String documentPath = "/net/shibboleth/shared/spring/httpclient/resource/document.xml";
    private final String existsURL = RepositorySupport.buildHTTPResourceURL("java-shib-shared", "shib-networking-spring/src/test/resources/net/shibboleth/shared/spring/httpclient/resource/document.xml", false);
    private final String nonExistsURL = RepositorySupport.buildHTTPResourceURL("java-shib-shared", "trunk/src/test/resources/data/document.xml", false);
    private String existsFile;
    private HttpClient client;

    @BeforeClass
    public void setupClient() throws Exception {
        this.client = new HttpClientBuilder().buildClient();
        File file = File.createTempFile("FileBackedHTTPResourceTest1", ".xml");
        this.existsFile = file.getAbsolutePath();
    }

    @AfterClass
    public void deleteFile() {
        File f = new File(this.existsFile);
        if (f.exists()) {
            f.delete();
        }
    }

    @Test
    public void existsTest() throws IOException {
        FileBackedHTTPResource existsResource = new FileBackedHTTPResource(this.existsFile, this.client, this.existsURL);
        FileBackedHTTPResource notExistsResource = new FileBackedHTTPResource(this.existsFile + "ZZZ", this.client, this.nonExistsURL);
        Assert.assertTrue((boolean)existsResource.exists());
        Assert.assertFalse((boolean)notExistsResource.exists());
    }

    @Test
    public void testCompare() throws IOException {
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)new FileBackedHTTPResource(this.existsFile, this.client, this.existsURL), (Resource)new ClassPathResource("/net/shibboleth/shared/spring/httpclient/resource/document.xml")));
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)new FileBackedHTTPResource(this.existsFile, this.client, this.nonExistsURL), (Resource)new ClassPathResource("/net/shibboleth/shared/spring/httpclient/resource/document.xml")));
    }

    public GenericApplicationContext getContext(String location) {
        MockPropertySource mockEnvVars = new MockPropertySource();
        mockEnvVars.setProperty("file.name", (Object)this.existsFile);
        mockEnvVars.setProperty("the.url", (Object)this.existsURL);
        ApplicationContextBuilder builder = new ApplicationContextBuilder();
        builder.setUnresolvedServiceConfigurations((Collection)CollectionSupport.singletonList((Object)location));
        builder.setPropertySources(CollectionSupport.singletonList((Object)mockEnvVars));
        return builder.build();
    }

    @Test
    public void testParsingNew() throws IOException {
        try (GenericApplicationContext context = this.getContext("net/shibboleth/shared/spring/httpclient/resource/newStyle.xml");){
            Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)context.getBean("namedString", FileBackedHTTPResource.class), (Resource)new ClassPathResource("/net/shibboleth/shared/spring/httpclient/resource/document.xml")));
            Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)context.getBean("namedURL", FileBackedHTTPResource.class), (Resource)new ClassPathResource("/net/shibboleth/shared/spring/httpclient/resource/document.xml")));
            Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)context.getBean("numberedString", FileBackedHTTPResource.class), (Resource)new ClassPathResource("/net/shibboleth/shared/spring/httpclient/resource/document.xml")));
            Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)context.getBean("numberedURL", FileBackedHTTPResource.class), (Resource)new ClassPathResource("/net/shibboleth/shared/spring/httpclient/resource/document.xml")));
        }
    }
}

