/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.httpclient.resource;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Collection;
import net.shibboleth.shared.httpclient.HttpClientBuilder;
import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import net.shibboleth.shared.httpclient.InMemoryCachingHttpClientBuilder;
import net.shibboleth.shared.spring.custom.SchemaTypeAwareXMLBeanDefinitionReader;
import net.shibboleth.shared.spring.httpclient.resource.HTTPResource;
import net.shibboleth.shared.spring.httpclient.resource.RepositorySupport;
import net.shibboleth.shared.spring.httpclient.resource.ResourceTestHelper;
import net.shibboleth.shared.spring.httpclient.resource.TestHTTPResource;
import org.apache.hc.client5.http.cache.CacheResponseStatus;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class HTTPResourceTest {
    private final String documentPath = "/net/shibboleth/shared/spring/httpclient/resource/document.xml";
    private final String existsURL = "http://git.shibboleth.net/view/?p=java-shib-shared.git;a=blob_plain;f=shib-networking-spring/src/test/resources/net/shibboleth/shared/spring/httpclient/resource/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD";
    private final String nonExistsURL = RepositorySupport.buildHTTPResourceURL("java-shib-shared", "trunk/src/test/resources/data/document.xml", false);
    private HttpClient client;

    @BeforeClass
    public void setupClient() throws Exception {
        this.client = new HttpClientBuilder().buildClient();
    }

    @Test
    public void existsTest() throws IOException {
        HTTPResource existsResource = new HTTPResource(this.client, "http://git.shibboleth.net/view/?p=java-shib-shared.git;a=blob_plain;f=shib-networking-spring/src/test/resources/net/shibboleth/shared/spring/httpclient/resource/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD");
        HTTPResource notExistsResource = new HTTPResource(this.client, this.nonExistsURL);
        Assert.assertTrue((boolean)existsResource.exists());
        Assert.assertFalse((boolean)notExistsResource.exists());
    }

    @Test
    public void contextHandlerNoopTest() throws IOException {
        HTTPResource existsResource = new HTTPResource(this.client, "http://git.shibboleth.net/view/?p=java-shib-shared.git;a=blob_plain;f=shib-networking-spring/src/test/resources/net/shibboleth/shared/spring/httpclient/resource/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD");
        existsResource.setHttpClientContextHandler(new HttpClientContextHandler(){

            public void invokeBefore(HttpClientContext context, ClassicHttpRequest request) throws IOException {
            }

            public void invokeAfter(HttpClientContext context, ClassicHttpRequest request) throws IOException {
            }
        });
        Assert.assertTrue((boolean)existsResource.exists());
    }

    @Test
    public void contextHandlerFailBeforeTest() throws IOException {
        HTTPResource existsResource = new HTTPResource(this.client, "http://git.shibboleth.net/view/?p=java-shib-shared.git;a=blob_plain;f=shib-networking-spring/src/test/resources/net/shibboleth/shared/spring/httpclient/resource/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD");
        existsResource.setHttpClientContextHandler(new HttpClientContextHandler(){

            public void invokeBefore(HttpClientContext context, ClassicHttpRequest request) throws IOException {
                throw new IOException("Fail");
            }

            public void invokeAfter(HttpClientContext context, ClassicHttpRequest request) throws IOException {
            }
        });
        Assert.assertFalse((boolean)existsResource.exists());
    }

    @Test
    public void contextHandlerFailAfterTest() throws IOException {
        HTTPResource existsResource = new HTTPResource(this.client, "http://git.shibboleth.net/view/?p=java-shib-shared.git;a=blob_plain;f=shib-networking-spring/src/test/resources/net/shibboleth/shared/spring/httpclient/resource/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD");
        existsResource.setHttpClientContextHandler(new HttpClientContextHandler(){

            public void invokeBefore(HttpClientContext context, ClassicHttpRequest request) throws IOException {
            }

            public void invokeAfter(HttpClientContext context, ClassicHttpRequest request) throws IOException {
                throw new IOException("Fail");
            }
        });
        Assert.assertFalse((boolean)existsResource.exists());
    }

    @Test
    public void testCompare() throws IOException {
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)new HTTPResource(this.client, "http://git.shibboleth.net/view/?p=java-shib-shared.git;a=blob_plain;f=shib-networking-spring/src/test/resources/net/shibboleth/shared/spring/httpclient/resource/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD"), (Resource)new ClassPathResource("/net/shibboleth/shared/spring/httpclient/resource/document.xml")));
    }

    @Test
    public void testRelated() throws IOException {
        HTTPResource parent = new HTTPResource(this.client, "http://test.shibboleth.net/downloads/identity-provider/archive/2.0.0/");
        HTTPResource child = parent.createRelative("shibboleth-idp-2.0.0-bin.zip");
        long when = child.lastModified();
        long size = child.contentLength();
        String whenAsString = Instant.ofEpochMilli(when).toString();
        Assert.assertEquals((long)when, (long)1588006169000L, (String)("Expected date of " + whenAsString + " did not match)"));
        Assert.assertEquals((long)size, (long)20784226L, (String)"Size mismatch");
    }

    @Test
    public void testCachedNoCache() throws IOException, InterruptedException {
        TestHTTPResource what = new TestHTTPResource(this.client, "http://git.shibboleth.net/view/?p=java-shib-shared.git;a=blob_plain;f=shib-networking-spring/src/test/resources/net/shibboleth/shared/spring/httpclient/resource/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD");
        Assert.assertTrue((boolean)what.exists());
        Assert.assertNull((Object)what.getLastCacheResponseStatus());
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)what, (Resource)new ClassPathResource("/net/shibboleth/shared/spring/httpclient/resource/document.xml")));
        Assert.assertNull((Object)what.getLastCacheResponseStatus());
    }

    @Test
    public void testCachedCache() throws Exception {
        InMemoryCachingHttpClientBuilder builder = new InMemoryCachingHttpClientBuilder();
        builder.setMaxCacheEntries(3);
        TestHTTPResource what = new TestHTTPResource(builder.buildClient(), "http://git.shibboleth.net/view/?p=java-shib-shared.git;a=blob_plain;f=shib-networking-spring/src/test/resources/net/shibboleth/shared/spring/httpclient/resource/document.xml;h=e8ec7c0d20c7a6b8193e1868398cda0c28df45ed;hb=HEAD");
        Assert.assertTrue((boolean)what.exists());
        Assert.assertNotNull((Object)what.getLastCacheResponseStatus());
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)what, (Resource)new ClassPathResource("/net/shibboleth/shared/spring/httpclient/resource/document.xml")));
        Assert.assertEquals((Object)what.getLastCacheResponseStatus(), (Object)CacheResponseStatus.CACHE_HIT);
    }

    private GenericApplicationContext getContext(String fileName, File theDir) {
        GenericApplicationContext parentContext = new GenericApplicationContext();
        parentContext.refresh();
        if (theDir != null) {
            parentContext.getBeanFactory().registerSingleton("theDir", (Object)theDir);
        }
        GenericApplicationContext context = new GenericApplicationContext((ApplicationContext)parentContext);
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.setValidationMode(3);
        beanDefinitionReader.loadBeanDefinitions(fileName);
        context.refresh();
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void springLoadMemCache() throws IOException {
        GenericApplicationContext context = this.getContext("classpath:/net/shibboleth/shared/spring/httpclient/resource/MemBackedHTTPBean.xml", null);
        try {
            Collection beans = context.getBeansOfType(TestHTTPResource.class).values();
            Assert.assertEquals((int)beans.size(), (int)1);
            TestHTTPResource what = (TestHTTPResource)((Object)beans.iterator().next());
            Assert.assertTrue((boolean)what.exists());
            Assert.assertNotNull((Object)what.getLastCacheResponseStatus());
            Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)what, (Resource)new ClassPathResource("/net/shibboleth/shared/spring/httpclient/resource/document.xml")));
            Assert.assertEquals((Object)what.getLastCacheResponseStatus(), (Object)CacheResponseStatus.CACHE_HIT);
        }
        finally {
            ApplicationContext parent = context.getParent();
            if (parent instanceof GenericApplicationContext) {
                ((GenericApplicationContext)parent).close();
            }
            context.close();
        }
    }

    private void emptyDir(File dir) {
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                this.emptyDir(f);
            }
            Assert.assertTrue((boolean)f.delete());
        }
        Assert.assertTrue((boolean)dir.delete());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void springLoadFileCache() throws IOException {
        File theDir = null;
        GenericApplicationContext context = null;
        try {
            Path p = Files.createTempDirectory("HTTPResourceTest", new FileAttribute[0]);
            theDir = p.toFile();
            context = this.getContext("classpath:/net/shibboleth/shared/spring/httpclient/resource/MemBackedHTTPBean.xml", null);
            Collection beans = context.getBeansOfType(TestHTTPResource.class).values();
            Assert.assertEquals((int)beans.size(), (int)1);
            TestHTTPResource what = (TestHTTPResource)((Object)beans.iterator().next());
            Assert.assertTrue((boolean)what.exists());
            Assert.assertNotNull((Object)what.getLastCacheResponseStatus());
            Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)what, (Resource)new ClassPathResource("/net/shibboleth/shared/spring/httpclient/resource/document.xml")));
            Assert.assertEquals((Object)what.getLastCacheResponseStatus(), (Object)CacheResponseStatus.CACHE_HIT);
        }
        finally {
            ApplicationContext parent;
            if (null != theDir) {
                this.emptyDir(theDir);
            }
            if (null != context && (parent = context.getParent()) instanceof GenericApplicationContext) {
                ((GenericApplicationContext)parent).close();
            }
        }
    }

    @Test(timeOut=5000L)
    public void testCloseResponse() {
        try (PoolingHttpClientConnectionManager connMgr = new PoolingHttpClientConnectionManager();){
            HTTPResource notExistsResource = new HTTPResource(this.client, this.nonExistsURL);
            int count = 0;
            while (count <= connMgr.getDefaultMaxPerRoute()) {
                ++count;
                try {
                    notExistsResource.getInputStream();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            Assert.fail((String)"Bad URL", (Throwable)e);
        }
    }
}

