/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.servlet.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.shibboleth.shared.servlet.impl.HttpServletRequestResponseContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HttpServletRequestResponseContextTest {
    private HttpServletRequest request;
    private HttpServletResponse response;

    @BeforeMethod
    public void setUp() {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest();
        mockRequest.setMethod("GET");
        mockRequest.setRequestURI("/foo");
        mockRequest.addHeader("MyRequestHeader", (Object)"MyRequestHeaderValue");
        mockRequest.addParameter("MyParam", "MyParamValue");
        this.request = mockRequest;
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        mockResponse.setHeader("MyResponseHeader", "MyResponseHeaderValue");
        this.response = mockResponse;
    }

    @AfterMethod
    public void tearDown() {
        HttpServletRequestResponseContext.clearCurrent();
    }

    @Test
    public void testLoadAndClear() {
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)this.request, (HttpServletResponse)this.response);
        Assert.assertNotNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNotNull((Object)HttpServletRequestResponseContext.getResponse());
        HttpServletRequest request = HttpServletRequestResponseContext.getRequest();
        assert (request != null);
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((String)request.getRequestURI(), (String)"/foo");
        Assert.assertEquals((String)request.getHeader("MyRequestHeader"), (String)"MyRequestHeaderValue");
        Assert.assertEquals((String)request.getParameter("MyParam"), (String)"MyParamValue");
        HttpServletResponse response = HttpServletRequestResponseContext.getResponse();
        assert (response != null);
        Assert.assertTrue((boolean)response.containsHeader("MyResponseHeader"));
        HttpServletRequestResponseContext.clearCurrent();
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
    }
}

