/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.httpclient;

import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import net.shibboleth.shared.httpclient.ContextHandlingHttpClient;
import net.shibboleth.shared.httpclient.HttpClientBuilder;
import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import net.shibboleth.shared.logic.ConstraintViolationException;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HttpClientBuilderTest {
    @Test
    public void JSPT66() throws Exception {
        HttpClientBuilder builder = new HttpClientBuilder();
        Assert.assertEquals((Object)builder.getConnectionTimeout(), (Object)Duration.ofSeconds(60L));
        Assert.assertEquals((Object)builder.getSocketTimeout(), (Object)Duration.ofSeconds(60L));
        Assert.assertEquals((Object)builder.getConnectionRequestTimeout(), (Object)Duration.ofSeconds(60L));
        try {
            builder.setSocketTimeout(Duration.ofMillis(Long.MAX_VALUE));
            Assert.fail();
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
        HttpClient client = builder.buildClient();
        Assert.assertNotNull((Object)client);
    }

    @Test
    public void testContextHandlingSupport() throws Exception {
        TestContextHandler handler1 = new TestContextHandler();
        TestContextHandler handler2 = new TestContextHandler();
        TestContextHandler handler3 = new TestContextHandler();
        HttpClientBuilder builder = new HttpClientBuilder();
        Assert.assertNotNull((Object)builder.getStaticContextHandlers());
        Assert.assertTrue((boolean)builder.getStaticContextHandlers().isEmpty());
        builder.setStaticContextHandlers(List.of(handler1, handler2, handler3));
        Assert.assertEquals((Collection)builder.getStaticContextHandlers(), List.of(handler1, handler2, handler3));
        try {
            builder.getStaticContextHandlers().add(new TestContextHandler());
            Assert.fail((String)"List should have been unmodifaible");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        builder.resetDefaults();
        Assert.assertNotNull((Object)builder.getStaticContextHandlers());
        Assert.assertTrue((boolean)builder.getStaticContextHandlers().isEmpty());
        HttpClient client = builder.buildClient();
        Assert.assertNotNull((Object)client);
        Assert.assertTrue((boolean)ContextHandlingHttpClient.class.isInstance(client));
    }

    public class TestContextHandler
    implements HttpClientContextHandler {
        public void invokeBefore(HttpClientContext context, ClassicHttpRequest request) throws IOException {
        }

        public void invokeAfter(HttpClientContext context, ClassicHttpRequest request) throws IOException {
        }
    }
}

