/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.net;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import javax.annotation.Nonnull;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.net.CookieManager;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CookieManagerTest {
    @Test
    public void testInitFailure() {
        CookieManager cm = new CookieManager();
        try {
            cm.initialize();
            Assert.fail();
        }
        catch (ComponentInitializationException componentInitializationException) {
            // empty catch block
        }
    }

    @Test
    public void testInitSuccess() throws ComponentInitializationException {
        final MockHttpServletRequest request = new MockHttpServletRequest();
        final MockHttpServletResponse response = new MockHttpServletResponse();
        CookieManager cm = new CookieManager();
        cm.setHttpServletRequestSupplier((NonnullSupplier)new NonnullSupplier<HttpServletRequest>(){

            @Nonnull
            public HttpServletRequest get() {
                return request;
            }
        });
        cm.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            @Nonnull
            public HttpServletResponse get() {
                return response;
            }
        });
        cm.initialize();
    }

    @Test
    public void testCookieWithPath() throws ComponentInitializationException {
        final MockHttpServletRequest request = new MockHttpServletRequest();
        final MockHttpServletResponse response = new MockHttpServletResponse();
        CookieManager cm = new CookieManager();
        cm.setHttpServletRequestSupplier((NonnullSupplier)new NonnullSupplier<HttpServletRequest>(){

            @Nonnull
            public HttpServletRequest get() {
                return request;
            }
        });
        cm.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            @Nonnull
            public HttpServletResponse get() {
                return response;
            }
        });
        cm.setCookiePath("/idp");
        cm.initialize();
        cm.addCookie("foo", "bar");
        Cookie cookie = response.getCookie("foo");
        assert (cookie != null);
        Assert.assertEquals((String)cookie.getValue(), (String)"bar");
        Assert.assertEquals((String)cookie.getPath(), (String)"/idp");
        Assert.assertNull((Object)cookie.getDomain());
        Assert.assertTrue((boolean)cookie.getSecure());
        Assert.assertEquals((int)cookie.getMaxAge(), (int)-1);
    }

    @Test
    public void testCookieNoPath() throws ComponentInitializationException {
        final MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/idp");
        final MockHttpServletResponse response = new MockHttpServletResponse();
        CookieManager cm = new CookieManager();
        cm.setHttpServletRequestSupplier((NonnullSupplier)new NonnullSupplier<HttpServletRequest>(){

            @Nonnull
            public HttpServletRequest get() {
                return request;
            }
        });
        cm.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            @Nonnull
            public HttpServletResponse get() {
                return response;
            }
        });
        cm.initialize();
        cm.addCookie("foo", "bar");
        Cookie cookie = response.getCookie("foo");
        assert (cookie != null);
        Assert.assertEquals((String)cookie.getValue(), (String)"bar");
        Assert.assertEquals((String)cookie.getPath(), (String)"/idp");
        Assert.assertNull((Object)cookie.getDomain());
        Assert.assertTrue((boolean)cookie.getSecure());
        Assert.assertEquals((int)cookie.getMaxAge(), (int)-1);
    }

    @Test
    public void testCookieUnset() throws ComponentInitializationException {
        final MockHttpServletRequest request = new MockHttpServletRequest();
        request.setContextPath("/idp");
        request.setCookies(new Cookie[]{new Cookie("foo", "bar")});
        final MockHttpServletResponse response = new MockHttpServletResponse();
        CookieManager cm = new CookieManager();
        cm.setHttpServletRequestSupplier((NonnullSupplier)new NonnullSupplier<HttpServletRequest>(){

            @Nonnull
            public HttpServletRequest get() {
                return request;
            }
        });
        cm.setHttpServletResponseSupplier((NonnullSupplier)new NonnullSupplier<HttpServletResponse>(){

            @Nonnull
            public HttpServletResponse get() {
                return response;
            }
        });
        cm.initialize();
        cm.unsetCookie("foo");
        Cookie cookie = response.getCookie("foo");
        assert (cookie != null);
        Assert.assertNull((Object)cookie.getValue());
        Assert.assertEquals((String)cookie.getPath(), (String)"/idp");
        Assert.assertNull((Object)cookie.getDomain());
        Assert.assertTrue((boolean)cookie.getSecure());
        Assert.assertEquals((int)cookie.getMaxAge(), (int)0);
    }
}

