/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.net;

import com.google.common.net.MediaType;
import java.util.Set;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.net.MediaTypeSupport;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MediaTypeSupportTest {
    @Test
    public void testValidateContentType() {
        String contentType = null;
        Assert.assertTrue((boolean)MediaTypeSupport.validateContentType(contentType, (Set)CollectionSupport.singleton((Object)MediaType.XML_UTF_8), (boolean)true, (boolean)false));
        Assert.assertFalse((boolean)MediaTypeSupport.validateContentType(contentType, (Set)CollectionSupport.singleton((Object)MediaType.XML_UTF_8), (boolean)false, (boolean)false));
        contentType = "text/xml; charset=utf-8";
        Assert.assertFalse((boolean)MediaTypeSupport.validateContentType((String)contentType, (Set)CollectionSupport.singleton((Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)false));
        Assert.assertTrue((boolean)MediaTypeSupport.validateContentType((String)contentType, (Set)CollectionSupport.setOf((Object)MediaType.XML_UTF_8, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)false));
        Assert.assertTrue((boolean)MediaTypeSupport.validateContentType((String)contentType, (Set)CollectionSupport.setOf((Object)MediaType.XML_UTF_8, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)MediaTypeSupport.validateContentType((String)contentType, (Set)CollectionSupport.setOf((Object)MediaType.XML_UTF_8.withoutParameters(), (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)MediaTypeSupport.validateContentType((String)contentType, (Set)CollectionSupport.setOf((Object)MediaType.ANY_TEXT_TYPE, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)MediaTypeSupport.validateContentType((String)contentType, (Set)CollectionSupport.setOf((Object)MediaType.ANY_TYPE, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
        contentType = "text/xml";
        Assert.assertFalse((boolean)MediaTypeSupport.validateContentType((String)contentType, (Set)CollectionSupport.singleton((Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)false));
        Assert.assertTrue((boolean)MediaTypeSupport.validateContentType((String)contentType, (Set)CollectionSupport.setOf((Object)MediaType.XML_UTF_8, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)false));
        Assert.assertFalse((boolean)MediaTypeSupport.validateContentType((String)contentType, (Set)CollectionSupport.setOf((Object)MediaType.XML_UTF_8, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)MediaTypeSupport.validateContentType((String)contentType, (Set)CollectionSupport.setOf((Object)MediaType.XML_UTF_8.withoutParameters(), (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)MediaTypeSupport.validateContentType((String)contentType, (Set)CollectionSupport.setOf((Object)MediaType.ANY_TEXT_TYPE, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)MediaTypeSupport.validateContentType((String)contentType, (Set)CollectionSupport.setOf((Object)MediaType.ANY_TYPE, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
    }
}

