/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.servlet.impl;

import com.google.common.net.MediaType;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Set;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.servlet.HttpServletSupport;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HttpServletSupportTest {
    @Test
    public void testAddNoCacheHeaders() {
        MockHttpServletResponse response = new MockHttpServletResponse();
        Assert.assertNull((Object)response.getHeaderValue("Cache-control"));
        Assert.assertNull((Object)response.getHeaderValue("Pragma"));
        HttpServletSupport.addNoCacheHeaders((HttpServletResponse)response);
        Assert.assertEquals((Object)response.getHeaderValue("Cache-control"), (Object)"no-cache, no-store");
        Assert.assertEquals((Object)response.getHeaderValue("Pragma"), (Object)"no-cache");
    }

    @Test
    public void testGetFullRequestURI() {
    }

    @Test
    public void testGetRequestPathWithoutContext() {
    }

    @Test
    public void testSetContentType() {
    }

    @Test
    public void testSetUTF8Encoding() {
    }

    @Test
    public void testValidateContentType() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)CollectionSupport.singleton((Object)MediaType.XML_UTF_8), (boolean)true, (boolean)false));
        Assert.assertFalse((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)CollectionSupport.singleton((Object)MediaType.XML_UTF_8), (boolean)false, (boolean)false));
        request.setContentType("text/xml; charset=utf-8");
        Assert.assertFalse((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)CollectionSupport.singleton((Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)false));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)CollectionSupport.setOf((Object)MediaType.XML_UTF_8, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)false));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)CollectionSupport.setOf((Object)MediaType.XML_UTF_8, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)CollectionSupport.setOf((Object)MediaType.XML_UTF_8.withoutParameters(), (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)CollectionSupport.setOf((Object)MediaType.ANY_TEXT_TYPE, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)CollectionSupport.setOf((Object)MediaType.ANY_TYPE, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
        request.setContentType("text/xml");
        Assert.assertFalse((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)CollectionSupport.singleton((Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)false));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)CollectionSupport.setOf((Object)MediaType.XML_UTF_8, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)false));
        Assert.assertFalse((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)CollectionSupport.setOf((Object)MediaType.XML_UTF_8, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)CollectionSupport.setOf((Object)MediaType.XML_UTF_8.withoutParameters(), (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)CollectionSupport.setOf((Object)MediaType.ANY_TEXT_TYPE, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
        Assert.assertTrue((boolean)HttpServletSupport.validateContentType((HttpServletRequest)request, (Set)CollectionSupport.setOf((Object)MediaType.ANY_TYPE, (Object)MediaType.create((String)"application", (String)"foobar")), (boolean)true, (boolean)true));
    }

    @Test
    public void testLanguageRanges() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        Assert.assertTrue((boolean)HttpServletSupport.getLanguageRange((HttpServletRequest)request).isEmpty());
        request.addHeader("Accept-Language", (Object)"en-GB,fr-FR;q=0.7,en;q=0.3");
        List ranges = HttpServletSupport.getLanguageRange((HttpServletRequest)request);
        Assert.assertEquals((int)ranges.size(), (int)4);
        request = new MockHttpServletRequest();
        request.addHeader("Accept-Language", (Object)"en-ca;en-us");
        ranges = HttpServletSupport.getLanguageRange((HttpServletRequest)request);
        Assert.assertTrue((boolean)ranges.isEmpty());
    }
}

