/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.httpclient;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.httpclient.AbstractHttpClient;
import net.shibboleth.shared.httpclient.ContextHandlingHttpClient;
import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import net.shibboleth.shared.httpclient.HttpClientSupport;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ContextHandlingHttpClientTest {
    public static final ClassicHttpResponse STATIC_RESPONSE_HTTP = new MockClassicHttpResponse(new ProtocolVersion("HTTP", 1, 1), 200, "OK");
    public static final Object STATIC_RESPONSE_HANDLER = new Object();
    private ContextHandlingHttpClient client;
    private TestContextHandler staticOne;
    private TestContextHandler staticTwo;
    private TestContextHandler staticThree;
    private TestContextHandler dynamicOne;
    private TestContextHandler dynamicTwo;
    private TestContextHandler dynamicThree;
    private HttpClientContext context;
    private ClassicHttpRequest request;
    private HttpHost target;
    private HttpClientResponseHandler<Object> responseHandler = new MockResponseHandler();

    @BeforeClass
    public void setupClass() {
        this.staticOne = new TestContextHandler("static-1");
        this.staticTwo = new TestContextHandler("static-2");
        this.staticThree = new TestContextHandler("static-3");
        this.dynamicOne = new TestContextHandler("dynamic-1");
        this.dynamicTwo = new TestContextHandler("dynamic-2");
        this.dynamicThree = new TestContextHandler("dynamic-3");
    }

    @BeforeMethod
    public void setupMethod() {
        this.request = new HttpGet("/test");
        this.target = new HttpHost("test.example.edu");
    }

    @Test
    public void testNoHandlers() throws IOException {
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient());
        this.context = HttpClientContext.create();
        assert (this.context != null);
        Assert.assertSame((Object)this.client.execute(this.request), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertSame((Object)this.client.execute(this.request, this.responseHandler), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertSame((Object)this.client.execute(this.target, this.request), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertSame((Object)this.client.execute(this.target, this.request, this.responseHandler), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertSame((Object)this.client.execute(this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertSame((Object)this.client.execute(this.request, (HttpContext)this.context, this.responseHandler), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertSame((Object)this.client.execute(this.target, this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertSame((Object)this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler), (Object)STATIC_RESPONSE_HANDLER);
    }

    @Test
    public void testStaticOnly() throws IOException {
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        List<String> control = List.of("before-static-1", "before-static-2", "before-static-3", "after-static-3", "after-static-2", "after-static-1");
        this.context = HttpClientContext.create();
        assert (this.context != null);
        Assert.assertSame((Object)this.client.execute(this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        this.context = HttpClientContext.create();
        assert (this.context != null);
        Assert.assertSame((Object)this.client.execute(this.request, (HttpContext)this.context, this.responseHandler), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        this.context = HttpClientContext.create();
        assert (this.context != null);
        Assert.assertSame((Object)this.client.execute(this.target, this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        this.context = HttpClientContext.create();
        Assert.assertSame((Object)this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
    }

    @Test
    public void testDynamicOnly() throws IOException {
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient());
        List<String> control = List.of("before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1");
        List<TestContextHandler> handlers = List.of(this.dynamicOne, this.dynamicTwo, this.dynamicThree);
        this.context = HttpClientContext.create();
        assert (this.context != null);
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        this.context = HttpClientContext.create();
        assert (this.context != null);
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.request, (HttpContext)this.context, this.responseHandler), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        this.context = HttpClientContext.create();
        assert (this.context != null);
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.target, this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        this.context = HttpClientContext.create();
        assert (this.context != null);
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
    }

    @Test
    public void testStaticAndDynamic() throws IOException {
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        List<String> control = List.of("before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1");
        List<TestContextHandler> handlers = List.of(this.dynamicOne, this.dynamicTwo, this.dynamicThree);
        this.context = HttpClientContext.create();
        assert (this.context != null);
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        this.context = HttpClientContext.create();
        assert (this.context != null);
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.request, (HttpContext)this.context, this.responseHandler), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        this.context = HttpClientContext.create();
        assert (this.context != null);
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.target, this.request, (HttpContext)this.context), (Object)STATIC_RESPONSE_HTTP);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        this.context = HttpClientContext.create();
        assert (this.context != null);
        HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
        Assert.assertSame((Object)this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler), (Object)STATIC_RESPONSE_HANDLER);
        Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
    }

    @Test
    public void testWrappedClientThrowsIOException() throws IOException {
        IOException error = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(error), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        List<String> control = List.of("before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1");
        List<TestContextHandler> handlers = List.of(this.dynamicOne, this.dynamicTwo, this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
    }

    @Test
    public void testWrappedClientThrowsRuntimeException() throws IOException {
        RuntimeException error = new RuntimeException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(error), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        List<String> control = List.of("before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1");
        List<TestContextHandler> handlers = List.of(this.dynamicOne, this.dynamicTwo, this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (RuntimeException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
    }

    @Test
    public void testWrappedClientThrowsError() throws IOException {
        Error error = new Error();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(error), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        List<String> control = List.of("before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1");
        List handlers = CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.dynamicOne, this.dynamicTwo, this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (Error e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (Error e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (Error e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (Error e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
    }

    @Test
    public void testSingleStaticHandlerInvokeBeforeThrowsIOException() throws IOException {
        IOException error = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", error, null), this.staticThree}));
        List<String> control = List.of("before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1");
        List<TestContextHandler> handlers = List.of(this.dynamicOne, this.dynamicTwo, this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
    }

    @Test
    public void testSingleStaticHandlerInvokeAfterThrowsIOException() throws IOException {
        IOException error = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", null, error), this.staticThree}));
        List<String> control = List.of("before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1");
        List<TestContextHandler> handlers = List.of(this.dynamicOne, this.dynamicTwo, this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
    }

    @Test
    public void testSingleStaticHandlerInvokeBeforeThrowsRuntimeException() throws IOException {
        RuntimeException error = new RuntimeException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", error, null), this.staticThree}));
        List<String> control = List.of("before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1");
        List<TestContextHandler> handlers = List.of(this.dynamicOne, this.dynamicTwo, this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
    }

    @Test
    public void testSingleStaticHandlerInvokeAfterThrowsRuntimeException() throws IOException {
        RuntimeException error = new RuntimeException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", null, error), this.staticThree}));
        List<String> control = List.of("before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1");
        List<TestContextHandler> handlers = List.of(this.dynamicOne, this.dynamicTwo, this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
    }

    @Test
    public void testMultipleStaticHandlersInvokeBeforeThrowIOException() throws IOException {
        IOException error1 = new IOException();
        IOException error3 = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{new TestContextHandler("static-1", error1, null), this.staticTwo, new TestContextHandler("static-3", error3, null)}));
        List<String> control = List.of("before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1");
        List<TestContextHandler> handlers = List.of(this.dynamicOne, this.dynamicTwo, this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
    }

    @Test
    public void testMultipleStaticHandlersInvokeBeforeThrowRuntimeException() throws IOException {
        RuntimeException error1 = new RuntimeException();
        RuntimeException error3 = new RuntimeException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{new TestContextHandler("static-1", error1, null), this.staticTwo, new TestContextHandler("static-3", error3, null)}));
        List<String> control = List.of("before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1");
        List<TestContextHandler> handlers = List.of(this.dynamicOne, this.dynamicTwo, this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
    }

    @Test
    public void testMultipleStaticHandlersInvokeAfterThrowIOException() throws IOException {
        IOException error1 = new IOException();
        IOException error3 = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{new TestContextHandler("static-1", null, error1), this.staticTwo, new TestContextHandler("static-3", null, error3)}));
        List<String> control = List.of("before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1");
        List<TestContextHandler> handlers = List.of(this.dynamicOne, this.dynamicTwo, this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
    }

    @Test
    public void testMultipleStaticHandlersInvokeAfterThrowRuntimeException() throws IOException {
        RuntimeException error1 = new RuntimeException();
        RuntimeException error3 = new RuntimeException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{new TestContextHandler("static-1", null, error1), this.staticTwo, new TestContextHandler("static-3", null, error3)}));
        List<String> control = List.of("before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1");
        List<TestContextHandler> handlers = List.of(this.dynamicOne, this.dynamicTwo, this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), control);
        }
    }

    @Test
    public void testSingleDynamicHandlerInvokeBeforeThrowsIOException() throws IOException {
        IOException error = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        List control = CollectionSupport.listOf((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        List<TestContextHandler> handlers = List.of(this.dynamicOne, new TestContextHandler("dynamic-2", error, null), this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testSingleDynamicHandlerInvokeAfterThrowsIOException() throws IOException {
        IOException error = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        List control = CollectionSupport.listOf((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        List<TestContextHandler> handlers = List.of(this.dynamicOne, new TestContextHandler("dynamic-2", null, error), this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testSingleDynamicHandlerInvokeBeforeThrowsRuntimeException() throws IOException {
        RuntimeException error = new RuntimeException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        List control = CollectionSupport.listOf((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        List<TestContextHandler> handlers = List.of(this.dynamicOne, new TestContextHandler("dynamic-2", error, null), this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testSingleDynamicHandlerInvokeAfterThrowsRuntimeException() throws IOException {
        RuntimeException error = new RuntimeException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        List control = CollectionSupport.listOf((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        List<TestContextHandler> handlers = List.of(this.dynamicOne, new TestContextHandler("dynamic-2", null, error), this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)error);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testMultipleDynamicHandlersInvokeBeforeThrowIOException() throws IOException {
        IOException error1 = new IOException();
        IOException error3 = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        List control = CollectionSupport.listOf((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        List<TestContextHandler> handlers = List.of(new TestContextHandler("dynamic-1", error1, null), this.dynamicTwo, new TestContextHandler("dynamic-3", error3, null));
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testMultipleDynamicHandlersInvokeBeforeThrowRuntimeException() throws IOException {
        RuntimeException error1 = new RuntimeException();
        RuntimeException error3 = new RuntimeException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        List control = CollectionSupport.listOf((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        List<TestContextHandler> handlers = List.of(new TestContextHandler("dynamic-1", error1, null), this.dynamicTwo, new TestContextHandler("dynamic-3", error3, null));
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testMultipleDynamicHandlersInvokeAfterThrowIOException() throws IOException {
        IOException error1 = new IOException();
        IOException error3 = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        List control = CollectionSupport.listOf((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        List<TestContextHandler> handlers = List.of(new TestContextHandler("dynamic-1", null, error1), this.dynamicTwo, new TestContextHandler("dynamic-3", null, error3));
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testMultipleDynamicHandlersInvokeAfterThrowRuntimeException() throws IOException {
        RuntimeException error1 = new RuntimeException();
        RuntimeException error3 = new RuntimeException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        List control = CollectionSupport.listOf((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        List<TestContextHandler> handlers = List.of(new TestContextHandler("dynamic-1", null, error1), this.dynamicTwo, new TestContextHandler("dynamic-3", null, error3));
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertNotSame((Object)e, (Object)error1);
            Assert.assertNotSame((Object)e, (Object)error3);
            Assert.assertEquals((int)e.getSuppressed().length, (int)2);
            Assert.assertTrue((boolean)Arrays.asList(e.getSuppressed()).containsAll(List.of(error1, error3)));
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testStaticAndDynamicHandlersThrowIOException() throws IOException {
        IOException staticBeforeError = null;
        IOException dynamicAfterError = null;
        List control = CollectionSupport.listOf((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        List dynamicHandlers = null;
        staticBeforeError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", staticBeforeError, null), this.staticThree}));
        dynamicHandlers = CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        staticBeforeError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", staticBeforeError, null), this.staticThree}));
        dynamicHandlers = List.of(this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        staticBeforeError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", staticBeforeError, null), this.staticThree}));
        dynamicHandlers = CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        staticBeforeError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", staticBeforeError, null), this.staticThree}));
        dynamicHandlers = CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree});
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testStaticAndDynamicHandlersThrowRuntimeException() throws IOException {
        RuntimeException staticBeforeError = new RuntimeException();
        RuntimeException dynamicAfterError = new RuntimeException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, new TestContextHandler("static-2", staticBeforeError, null), this.staticThree}));
        List control = CollectionSupport.listOf((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        List<TestContextHandler> handlers = List.of(this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0].getCause(), (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0].getCause(), (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0].getCause(), (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(handlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e.getCause(), (Object)staticBeforeError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0].getCause(), (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    @Test
    public void testWrappedClientThrowsIOExceptionInvokeAfterThrowsIOException() throws IOException {
        IOException clientError = null;
        IOException dynamicAfterError = null;
        List control = CollectionSupport.listOf((Object[])new String[]{"before-static-1", "before-static-2", "before-static-3", "before-dynamic-1", "before-dynamic-2", "before-dynamic-3", "after-dynamic-3", "after-dynamic-2", "after-dynamic-1", "after-static-3", "after-static-2", "after-static-1"});
        List<TestContextHandler> dynamicHandlers = null;
        clientError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(clientError), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        dynamicHandlers = List.of(this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)clientError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        clientError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(clientError), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        dynamicHandlers = List.of(this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)clientError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        clientError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(clientError), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        dynamicHandlers = List.of(this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)clientError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
        clientError = new IOException();
        dynamicAfterError = new IOException();
        this.client = new ContextHandlingHttpClient((HttpClient)new MockHttpClient(clientError), CollectionSupport.listOf((Object[])new HttpClientContextHandler[]{this.staticOne, this.staticTwo, this.staticThree}));
        dynamicHandlers = List.of(this.dynamicOne, new TestContextHandler("dynamic-2", null, dynamicAfterError), this.dynamicThree);
        try {
            this.context = HttpClientContext.create();
            assert (this.context != null);
            HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)this.context).addAll(dynamicHandlers);
            this.client.execute(this.target, this.request, (HttpContext)this.context, this.responseHandler);
            Assert.fail((String)"Wrapped client should have thrown");
        }
        catch (IOException e) {
            Assert.assertSame((Object)e, (Object)clientError);
            Assert.assertEquals((int)e.getSuppressed().length, (int)1);
            Assert.assertSame((Object)e.getSuppressed()[0], (Object)dynamicAfterError);
            Assert.assertEquals((Object)this.context.getAttribute("testKey"), (Object)control);
        }
    }

    public static class MockResponseHandler
    implements HttpClientResponseHandler<Object> {
        public Object handleResponse(ClassicHttpResponse response) throws IOException {
            return STATIC_RESPONSE_HANDLER;
        }
    }

    private class TestContextHandler
    implements HttpClientContextHandler {
        public static final String TEST_KEY = "testKey";
        private String name;
        private Throwable invokeBeforeError;
        private Throwable invokeAfterError;

        public TestContextHandler(String instanceName) {
            this.name = instanceName;
        }

        public TestContextHandler(String instanceName, Throwable beforeError, Throwable afterError) {
            this.name = instanceName;
            this.invokeBeforeError = beforeError;
            this.invokeAfterError = afterError;
        }

        public void invokeBefore(@Nonnull HttpClientContext context, @Nonnull ClassicHttpRequest request) throws IOException {
            if (this.name != null) {
                this.addValue(context, "before-" + this.name);
            }
            ThrowableHelper.checkAndThrowError(this.invokeBeforeError);
        }

        public void invokeAfter(@Nonnull HttpClientContext context, @Nonnull ClassicHttpRequest request) throws IOException {
            if (this.name != null) {
                this.addValue(context, "after-" + this.name);
            }
            ThrowableHelper.checkAndThrowError(this.invokeAfterError);
        }

        private void addValue(HttpClientContext context, String value) {
            ArrayList<String> attrib = (ArrayList<String>)context.getAttribute(TEST_KEY, List.class);
            if (attrib == null) {
                attrib = new ArrayList<String>();
                context.setAttribute(TEST_KEY, attrib);
            }
            attrib.add(value);
        }
    }

    private static class MockHttpClient
    extends AbstractHttpClient {
        private Throwable error;

        public MockHttpClient() {
        }

        public MockHttpClient(Throwable throwable) {
            this.error = throwable;
        }

        public void close() throws IOException {
        }

        public void close(CloseMode closeMode) {
        }

        protected ClassicHttpResponse doExecute(@Nullable HttpHost target, @Nonnull ClassicHttpRequest request, @Nullable HttpContext context) throws IOException {
            ThrowableHelper.checkAndThrowError(this.error);
            return STATIC_RESPONSE_HTTP;
        }
    }

    public static class MockClassicHttpResponse
    extends BasicClassicHttpResponse {
        private static final long serialVersionUID = -3530926876971302045L;

        public MockClassicHttpResponse(ProtocolVersion ver, int code, String reason) {
            super(code, reason);
            this.setVersion(ver);
        }

        public void close() throws IOException {
        }
    }

    public static class ThrowableHelper {
        public static void checkAndThrowError(Throwable t) throws IOException {
            if (t != null) {
                if (IOException.class.isInstance(t)) {
                    throw (IOException)IOException.class.cast(t);
                }
                if (RuntimeException.class.isInstance(t)) {
                    throw (RuntimeException)RuntimeException.class.cast(t);
                }
                if (Error.class.isInstance(t)) {
                    throw (Error)Error.class.cast(t);
                }
            }
        }
    }
}

