/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.httpclient;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.httpclient.HttpClientContextHandler;
import net.shibboleth.shared.httpclient.HttpClientSupport;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HttpClientSupportTest {
    @Test
    public void testAddDynamicContextHandlerFirst() {
        HttpClientContext context = HttpClientContext.create();
        TestContextHandler one = new TestContextHandler();
        TestContextHandler two = new TestContextHandler();
        TestContextHandler three = new TestContextHandler();
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)three);
        Assert.assertEquals((Collection)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)context), List.of(three, two, one));
    }

    @Test
    public void testAddDynamicContextHandlerLast() {
        HttpClientContext context = HttpClientContext.create();
        TestContextHandler one = new TestContextHandler();
        TestContextHandler two = new TestContextHandler();
        TestContextHandler three = new TestContextHandler();
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)three);
        Assert.assertEquals((Collection)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)context), List.of(one, two, three));
    }

    @Test
    public void testAddDynamicContextHandlerFirstUniqueInstances() {
        HttpClientContext context = HttpClientContext.create();
        TestContextHandler one = new TestContextHandler();
        TestContextHandler two = new TestContextHandler();
        TestContextHandler three = new TestContextHandler();
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)three);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)three);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)one);
        Assert.assertEquals((Collection)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)context), List.of(three, two, one));
    }

    @Test
    public void testAddDynamicContextHandlerLastUniqueInstances() {
        HttpClientContext context = HttpClientContext.create();
        TestContextHandler one = new TestContextHandler();
        TestContextHandler two = new TestContextHandler();
        TestContextHandler three = new TestContextHandler();
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)one);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)three);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)three);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)two);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)one);
        Assert.assertEquals((Collection)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)context), List.of(one, two, three));
    }

    @Test
    public void testAddDynamicContextHandlerFirstUniqueType() {
        HttpClientContext context = HttpClientContext.create();
        TestContextHandler one = new TestContextHandler();
        TestContextHandler two = new TestContextHandler();
        TestContextHandler three = new TestContextHandler();
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)one, (boolean)true);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)two, (boolean)true);
        HttpClientSupport.addDynamicContextHandlerFirst((HttpClientContext)context, (HttpClientContextHandler)three, (boolean)true);
        Assert.assertEquals((Collection)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)context), (Collection)CollectionSupport.singletonList((Object)one));
    }

    @Test
    public void testAddDynamicContextHandlerLastUniqueType() {
        HttpClientContext context = HttpClientContext.create();
        TestContextHandler one = new TestContextHandler();
        TestContextHandler two = new TestContextHandler();
        TestContextHandler three = new TestContextHandler();
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)one, (boolean)true);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)two, (boolean)true);
        HttpClientSupport.addDynamicContextHandlerLast((HttpClientContext)context, (HttpClientContextHandler)three, (boolean)true);
        Assert.assertEquals((Collection)HttpClientSupport.getDynamicContextHandlerList((HttpClientContext)context), (Collection)CollectionSupport.singletonList((Object)one));
    }

    public class TestContextHandler
    implements HttpClientContextHandler {
        public void invokeBefore(HttpClientContext context, ClassicHttpRequest request) throws IOException {
        }

        public void invokeAfter(HttpClientContext context, ClassicHttpRequest request) throws IOException {
        }
    }
}

