/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.servlet.impl;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.servlet.impl.HttpServletRequestResponseContext;
import net.shibboleth.shared.servlet.impl.ThreadLocalHttpServletRequestSupplier;
import net.shibboleth.shared.servlet.impl.ThreadLocalHttpServletResponseSupplier;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HttpServletRequestResponseContextTest {
    private HttpServletRequest request;
    private HttpServletResponse response;

    @BeforeMethod
    public void setUp() {
        MockHttpServletRequest mockRequest = new MockHttpServletRequest();
        mockRequest.setMethod("GET");
        mockRequest.setRequestURI("/foo");
        mockRequest.addHeader("MyRequestHeader", (Object)"MyRequestHeaderValue");
        mockRequest.addParameter("MyParam", "MyParamValue");
        this.request = mockRequest;
        MockHttpServletResponse mockResponse = new MockHttpServletResponse();
        mockResponse.setContentType("text/html");
        mockResponse.setCharacterEncoding("UTF-8");
        mockResponse.setHeader("MyResponseHeader", "MyResponseHeaderValue");
        this.response = mockResponse;
    }

    @AfterMethod
    public void tearDown() {
        HttpServletRequestResponseContext.clearCurrent();
    }

    @Test(expectedExceptions={ConstraintViolationException.class, IllegalStateException.class})
    public void testRequestNoLoad() {
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
        ThreadLocalHttpServletRequestSupplier proxy = new ThreadLocalHttpServletRequestSupplier();
        proxy.get().getMethod();
    }

    @Test
    public void testRequest() {
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)this.request, (HttpServletResponse)this.response);
        ThreadLocalHttpServletRequestSupplier proxy = new ThreadLocalHttpServletRequestSupplier();
        HttpServletRequest request = proxy.get();
        Assert.assertEquals((String)request.getMethod(), (String)"GET");
        Assert.assertEquals((String)request.getRequestURI(), (String)"/foo");
        Assert.assertEquals((String)request.getHeader("MyRequestHeader"), (String)"MyRequestHeaderValue");
        Assert.assertEquals((String)request.getParameter("MyParam"), (String)"MyParamValue");
        HttpServletRequestResponseContext.clearCurrent();
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
    }

    @Test(expectedExceptions={ConstraintViolationException.class, IllegalStateException.class})
    public void testResponseNoLoad() {
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
        ThreadLocalHttpServletResponseSupplier proxy = new ThreadLocalHttpServletResponseSupplier();
        proxy.get().getContentType();
    }

    @Test
    public void testResponse() {
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)this.request, (HttpServletResponse)this.response);
        ThreadLocalHttpServletResponseSupplier proxy = new ThreadLocalHttpServletResponseSupplier();
        HttpServletResponse response = proxy.get();
        Assert.assertEquals((String)response.getContentType(), (String)"text/html;charset=UTF-8");
        Assert.assertEquals((String)response.getCharacterEncoding(), (String)"UTF-8");
        Assert.assertTrue((boolean)response.containsHeader("MyResponseHeader"));
        HttpServletRequestResponseContext.clearCurrent();
        Assert.assertNull((Object)HttpServletRequestResponseContext.getRequest());
        Assert.assertNull((Object)HttpServletRequestResponseContext.getResponse());
    }
}

