/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.saml.profile.config;

import javax.annotation.Nullable;

import org.opensaml.profile.context.ProfileRequestContext;

import net.shibboleth.shared.annotation.ConfigurationSetting;

/** Common interface for SAML profile configurations involving artifact production. */
public interface SAMLArtifactAwareProfileConfiguration extends SAMLProfileConfiguration {
    
    /**
     * Get the associated {@link SAMLArtifactConfiguration} for the profile, if any.
     * 
     * @param profileRequestContext current profile request context
     * 
     * @return  an associated artifact configuration, or null
     */
    @ConfigurationSetting(name="artfactConfiguration")
    @Nullable SAMLArtifactConfiguration getArtifactConfiguration(
            @Nullable final ProfileRequestContext profileRequestContext); 
    
}