/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.saml.profile.config;

import javax.annotation.Nullable;

import org.opensaml.messaging.context.MessageContext;

import net.shibboleth.shared.annotation.ConfigurationSetting;

/**
 * Common interface for SAML profile configurations involving artifact consumption, for example artifact
 * resolution requests. 
 */
public interface SAMLArtifactConsumerProfileConfiguration extends SAMLProfileConfiguration {
    
    /**
     * Get whether artifact resolution requests should be signed.
     * 
     * @param messageContext current message context
     * 
     * @return whether artifact resolution requests should be signed
     */
    @ConfigurationSetting(name="signArtifactRequests")
    boolean isSignArtifactRequests(@Nullable final MessageContext messageContext); 

    /**
     * Get whether artifact resolution requests should use client TLS.
     * 
     * @param messageContext current message context
     * 
     * @return whether artifact resolution requests should use client TLS
     */
    @ConfigurationSetting(name="clientTLSArtifactRequests")
    boolean isClientTLSArtifactRequests(@Nullable final MessageContext messageContext); 

}