/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.saml.profile.config.navigate.messaging;


import java.util.function.Function;

import javax.annotation.Nullable;

import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.messaging.AbstractRelyingPartyLookupFunction;
import net.shibboleth.saml.profile.config.SAMLProfileConfiguration;

import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;

/**
 * A function that returns {@link SAMLProfileConfiguration#getMessageHandler(MessageContext)}
 * if such a profile is available from a {@link RelyingPartyContext} obtained via a lookup function,
 * by default a child of the {@link ProfileRequestContext}.
 * 
 * <p>If a specific setting is unavailable, a null value is returned.</p>
 */
public class MessageHandlerLookupFunction
        extends AbstractRelyingPartyLookupFunction<Function<MessageContext,Exception>> {

    /** {@inheritDoc} */
    @Nullable public Function<MessageContext,Exception> apply(@Nullable final MessageContext input) {
        final RelyingPartyContext rpc = getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null) {
            if (rpc.getProfileConfig() instanceof SAMLProfileConfiguration downcast) {
                return downcast.getMessageHandler(input);
            }
        }
        
        return null;
    }

}