/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.saml.profile.context.navigate.messaging;

import javax.annotation.Nullable;

import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.navigate.messaging.AbstractRelyingPartyLookupFunction;

import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.messaging.context.SAMLMetadataContext;

/**
 * A function to access a {@link SAMLMetadataContext} underlying a {@link RelyingPartyContext} located via a
 * lookup function.
 */
public class SAMLMetadataContextLookupFunction extends AbstractRelyingPartyLookupFunction<SAMLMetadataContext> {

    /** {@inheritDoc} */
    @Nullable public SAMLMetadataContext apply(@Nullable final MessageContext input) {
        final RelyingPartyContext rpCtx = getRelyingPartyContextLookupStrategy().apply(input);
        if (rpCtx != null) {
            final BaseContext peer = rpCtx.getRelyingPartyIdContextTree();
            if (peer != null) {
                if (peer instanceof SAMLMetadataContext) {
                    return (SAMLMetadataContext) peer;
                }
                return peer.getSubcontext(SAMLMetadataContext.class);    
            }
        }
        
        return null;
    }
    
}