/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.saml.saml1.profile.config;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.opensaml.profile.context.ProfileRequestContext;

import net.shibboleth.saml.profile.config.SAMLProfileConfiguration;
import net.shibboleth.shared.annotation.ConfigurationSetting;
import net.shibboleth.shared.annotation.constraint.NotEmpty;

/** Configuration support for SAML 1.x artifact resolution profile. */
public interface ArtifactResolutionProfileConfiguration extends SAMLProfileConfiguration {

    /** ID for this profile configuration. */
    @Nonnull @NotEmpty static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/saml1/query/artifact";
    
    /**
     * Get whether enclosed assertions should be signed.
     * 
     * @param profileRequestContext current profile request context
     * 
     * @return whether enclosed assertions should be signed
     */
    @ConfigurationSetting(name="signAssertions")
    boolean isSignAssertions(@Nullable final ProfileRequestContext profileRequestContext);

}