/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.saml.saml2.profile.config;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.opensaml.profile.context.ProfileRequestContext;

import net.shibboleth.shared.annotation.ConfigurationSetting;
import net.shibboleth.shared.annotation.constraint.NotEmpty;

/** Configuration support for SAML 2.0 artifact resolution profile. */
public interface ArtifactResolutionProfileConfiguration extends SAML2ProfileConfiguration {

    /** ID for this profile configuration. */
    @Nonnull @NotEmpty static final String PROFILE_ID = "http://shibboleth.net/ns/profiles/saml2/query/artifact";

    /**
     * Gets whether enclosed assertions should be signed.
     * 
     * @param profileRequestContext current profile request context
     * 
     * @return whether enclosed assertions should be signed
     */
    @ConfigurationSetting(name="signAssertions")
    boolean isSignAssertions(@Nullable final ProfileRequestContext profileRequestContext);
    
    /**
    * Gets whether enclosed assertions should be encrypted.
    * 
    * @param profileRequestContext current profile request context
    * 
    * @return whether enclosed assertions should be encrypted
    */
    @ConfigurationSetting(name="encryptAssertions")
    boolean isEncryptAssertions(@Nullable final ProfileRequestContext profileRequestContext);

    /**
     * Gets whether enclosed attributes should be encrypted.
     * 
     * @param profileRequestContext current profile request context
     * 
     * @return whether enclosed attributes should be encrypted
     */
    @ConfigurationSetting(name="encryptAttributes")
    boolean isEncryptAttributes(@Nullable final ProfileRequestContext profileRequestContext);

}