/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.saml.saml2.profile.config;

import javax.annotation.Nullable;

import org.opensaml.profile.context.ProfileRequestContext;

import net.shibboleth.saml.profile.config.SAMLAssertionProducingProfileConfiguration;
import net.shibboleth.shared.annotation.ConfigurationSetting;

/**
 * Interface for SAML 2.0 profiles that produce assertions.
 */
public interface SAML2AssertionProducingProfileConfiguration extends SAML2ProfileConfiguration,
        SAMLAssertionProducingProfileConfiguration {

    /**
     * Gets whether assertions should be encrypted.
     * 
     * @param profileRequestContext current profile request context
     * 
     * @return whether assertions should be encrypted
     */
    @ConfigurationSetting(name="encryptAssertions")
    boolean isEncryptAssertions(@Nullable final ProfileRequestContext profileRequestContext);

    /**
     * Gets whether attributes should be encrypted.
     * 
     * @param profileRequestContext current profile request context
     * 
     * @return whether attributes should be encrypted
     */
    @ConfigurationSetting(name="encryptAttributes")
    boolean isEncryptAttributes(@Nullable final ProfileRequestContext profileRequestContext);
}