/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.saml.saml2.profile.config.logic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.opensaml.profile.context.ProfileRequestContext;

import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.AbstractRelyingPartyPredicate;
import net.shibboleth.saml.saml2.profile.config.SAML2ProfileConfiguration;
import net.shibboleth.shared.primitive.LoggerFactory;

import org.slf4j.Logger;

/** Predicate that decides whether to ignore a request signature. */
public class IgnoreRequestSignaturesPredicate extends AbstractRelyingPartyPredicate {

    /** Class logger. */
    @Nonnull private final Logger log = LoggerFactory.getLogger(IgnoreRequestSignaturesPredicate.class);
    
    /** {@inheritDoc} */
    public boolean test(@Nullable final ProfileRequestContext input) {
        
        final RelyingPartyContext rpCtx = getRelyingPartyContext(input);
        if (rpCtx != null) {
            if (rpCtx.getProfileConfig() instanceof SAML2ProfileConfiguration downcast) {
                return downcast.isIgnoreRequestSignatures(input);
            }
        }
        
        log.debug("No SAML 2 profile configuration found, assuming signatures should be checked");
        return false;
    }

}