/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package net.shibboleth.saml.saml2.profile.config.logic.messaging;

import javax.annotation.Nullable;

import org.opensaml.messaging.context.MessageContext;

import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.messaging.AbstractRelyingPartyPredicate;
import net.shibboleth.saml.saml2.profile.config.SingleLogoutProfileConfiguration;

/** A predicate implementation that forwards to 
 * {@link SingleLogoutProfileConfiguration#isClientTLSSOAPRequests(MessageContext)}. */
public class ClientTLSSOAPLogoutRequestsPredicate extends AbstractRelyingPartyPredicate {
    
    /** {@inheritDoc} */
    public boolean test(@Nullable final MessageContext input) {
        final RelyingPartyContext rpc = getRelyingPartyContext(input);
        if (rpc != null) {
            if (rpc.getProfileConfig() instanceof SingleLogoutProfileConfiguration slo) {
                return slo.isClientTLSSOAPRequests(input);
            }
        }
        
        return false;
    }

}