/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.saml.profile.config;

import java.nio.ByteBuffer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.saml.profile.config.SAMLArtifactConfiguration;
import net.shibboleth.shared.component.IdentifiableComponent;
import net.shibboleth.shared.logic.ConstraintViolationException;
import net.shibboleth.shared.primitive.StringSupport;

public class BasicSAMLArtifactConfiguration
implements SAMLArtifactConfiguration,
IdentifiableComponent {
    @Nullable
    private String id;
    @Nullable
    private byte[] artifactType;
    @Nullable
    private String artifactResolutionURL;
    @Nullable
    private Integer artifactResolutionIndex;

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String componentId) {
        this.id = componentId;
    }

    @Override
    @Nullable
    public byte[] getArtifactType() {
        return this.artifactType;
    }

    public void setArtifactType(@Nullable Integer type) {
        if (type == null) {
            this.artifactType = null;
        } else {
            if (type <= 0) {
                throw new ConstraintViolationException("Artifact type code must be positive");
            }
            if (type > Short.MAX_VALUE) {
                throw new ConstraintViolationException("Artifact type code must fit in two bytes");
            }
            byte[] typeCode = ByteBuffer.allocate(4).putInt(type).array();
            byte[] atype = new byte[]{typeCode[2], typeCode[3]};
            this.artifactType = atype;
        }
    }

    @Override
    @Nullable
    public String getArtifactResolutionServiceURL() {
        return this.artifactResolutionURL;
    }

    public void setArtifactResolutionServiceURL(@Nullable String url) {
        this.artifactResolutionURL = StringSupport.trimOrNull((String)url);
    }

    @Override
    @Nullable
    public Integer getArtifactResolutionServiceIndex() {
        return this.artifactResolutionIndex;
    }

    public void setArtifactResolutionServiceIndex(@Nullable Integer index) {
        this.artifactResolutionIndex = index;
    }
}

