/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.saml.relyingparty;

import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.profile.context.logic.RelyingPartyIdPredicate;
import net.shibboleth.profile.relyingparty.BasicRelyingPartyConfiguration;
import net.shibboleth.saml.profile.context.logic.MappedEntityAttributesPredicate;
import net.shibboleth.saml.profile.context.navigate.SAMLMetadataContextLookupFunction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.StrategyIndirectedPredicate;
import org.opensaml.saml.common.messaging.context.navigate.EntityDescriptorLookupFunction;
import org.opensaml.saml.common.profile.logic.EntityAttributesPredicate;
import org.opensaml.saml.common.profile.logic.EntityGroupNamePredicate;
import org.opensaml.saml.metadata.resolver.MetadataResolver;

public final class RelyingPartyConfigurationSupport {
    private RelyingPartyConfigurationSupport() {
    }

    @Nonnull
    public static BasicRelyingPartyConfiguration byName(@Nonnull Collection<String> relyingPartyIds) {
        Constraint.isNotNull(relyingPartyIds, (String)"Relying Party ID list cannot be null");
        BasicRelyingPartyConfiguration config = new BasicRelyingPartyConfiguration();
        config.setActivationCondition((Predicate)new RelyingPartyIdPredicate(relyingPartyIds));
        StringBuffer name = new StringBuffer("EntityNames[");
        for (String rpId : relyingPartyIds) {
            name.append(rpId).append(',');
        }
        name.append(']');
        config.setId(name.toString());
        return config;
    }

    @Nonnull
    public static BasicRelyingPartyConfiguration byGroup(@Nonnull Collection<String> groupNames, @Nullable MetadataResolver resolver) {
        Constraint.isNotNull(groupNames, (String)"Group name list cannot be null");
        StrategyIndirectedPredicate indirectPredicate = new StrategyIndirectedPredicate(new EntityDescriptorLookupFunction().compose((Function)((Object)new SAMLMetadataContextLookupFunction())), (Predicate)new EntityGroupNamePredicate(groupNames, resolver));
        BasicRelyingPartyConfiguration config = new BasicRelyingPartyConfiguration();
        config.setActivationCondition((Predicate)indirectPredicate);
        StringBuffer name = new StringBuffer("EntityGroups[");
        for (String group : groupNames) {
            name.append(group).append(',');
        }
        name.append(']');
        config.setId(name.toString());
        return config;
    }

    @Nonnull
    public static BasicRelyingPartyConfiguration byTag(@Nonnull Collection<EntityAttributesPredicate.Candidate> candidates, boolean trim, boolean matchAll) {
        Constraint.isNotNull(candidates, (String)"Candidate list cannot be null");
        StrategyIndirectedPredicate indirectPredicate = new StrategyIndirectedPredicate(new EntityDescriptorLookupFunction().compose((Function)((Object)new SAMLMetadataContextLookupFunction())), (Predicate)new EntityAttributesPredicate(candidates, trim, matchAll));
        BasicRelyingPartyConfiguration config = new BasicRelyingPartyConfiguration();
        config.setActivationCondition((Predicate)indirectPredicate);
        return config;
    }

    @Nonnull
    public static BasicRelyingPartyConfiguration byMappedTag(@Nonnull Collection<EntityAttributesPredicate.Candidate> candidates, boolean trim, boolean matchAll) {
        Constraint.isNotNull(candidates, (String)"Candidate list cannot be null");
        StrategyIndirectedPredicate indirectPredicate = new StrategyIndirectedPredicate(new EntityDescriptorLookupFunction().compose((Function)((Object)new SAMLMetadataContextLookupFunction())), (Predicate)((Object)new MappedEntityAttributesPredicate(candidates, trim, matchAll)));
        BasicRelyingPartyConfiguration config = new BasicRelyingPartyConfiguration();
        config.setActivationCondition((Predicate)indirectPredicate);
        return config;
    }
}

