/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.saml.profile.context.logic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.attribute.transcoding.AttributeTranscoderRegistry;
import net.shibboleth.idp.saml.attribute.impl.AttributeMappingNodeProcessor;
import net.shibboleth.saml.profile.context.logic.MappedEntityAttributesPredicate;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import net.shibboleth.shared.service.ReloadableService;
import net.shibboleth.shared.spring.config.StringToDurationConverter;
import net.shibboleth.shared.spring.custom.SchemaTypeAwareXMLBeanDefinitionReader;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.common.profile.logic.EntityAttributesPredicate;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.filter.MetadataFilter;
import org.opensaml.saml.metadata.resolver.filter.impl.NodeProcessingMetadataFilter;
import org.opensaml.saml.metadata.resolver.impl.DOMMetadataResolver;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.context.support.ConversionServiceFactoryBean;
import org.springframework.context.support.GenericApplicationContext;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class EntityAttributesPredicateTest
extends XMLObjectBaseTestCase {
    @Nonnull
    @NotEmpty
    private String fooEntityID = "http://foo.example.org/shibboleth";
    @Nonnull
    @NotEmpty
    private String barEntityID = "http://bar.example.org/shibboleth";
    @Nonnull
    @NotEmpty
    private String bazEntityID = "http://baz.example.org/shibboleth";
    @Nullable
    private GenericApplicationContext pendingTeardownContext;
    @Nullable
    private MetadataResolver resolver;

    @BeforeClass
    protected void setUp() throws Exception {
        String mdFileName = "/net/shibboleth/saml/profile/context/logic/attribute-mapping-metadata.xml";
        Document mdDoc = parserPool.parse(((Object)((Object)this)).getClass().getResourceAsStream("/net/shibboleth/saml/profile/context/logic/attribute-mapping-metadata.xml"));
        DOMMetadataResolver mdProvider = new DOMMetadataResolver(mdDoc.getDocumentElement());
        ArrayList<AttributeMappingNodeProcessor> processors = new ArrayList<AttributeMappingNodeProcessor>();
        processors.add(new AttributeMappingNodeProcessor(this.getService()));
        NodeProcessingMetadataFilter nodeFilter = new NodeProcessingMetadataFilter();
        nodeFilter.setNodeProcessors(processors);
        nodeFilter.initialize();
        mdProvider.setMetadataFilter((MetadataFilter)nodeFilter);
        mdProvider.setId("Test");
        mdProvider.initialize();
        this.resolver = mdProvider;
    }

    @AfterClass
    public void tearDownTestContext() {
        if (null != this.pendingTeardownContext) {
            this.pendingTeardownContext.close();
            this.pendingTeardownContext = null;
        }
    }

    private void setTestContext(GenericApplicationContext context) {
        this.tearDownTestContext();
        this.pendingTeardownContext = context;
    }

    private EntityDescriptor getEntity(@Nonnull String entityID) throws ResolverException {
        assert (this.resolver != null);
        return (EntityDescriptor)this.resolver.resolveSingle((Object)new CriteriaSet(new Criterion[]{new EntityIdCriterion(entityID)}));
    }

    private ReloadableService<AttributeTranscoderRegistry> getService() {
        GenericApplicationContext context = new GenericApplicationContext();
        this.setTestContext(context);
        context.setDisplayName("ApplicationContext: ");
        ConversionServiceFactoryBean service = new ConversionServiceFactoryBean();
        service.setConverters(new HashSet(CollectionSupport.listOf((Object)new StringToDurationConverter())));
        service.afterPropertiesSet();
        context.getBeanFactory().setConversionService(service.getObject());
        SchemaTypeAwareXMLBeanDefinitionReader beanDefinitionReader = new SchemaTypeAwareXMLBeanDefinitionReader((BeanDefinitionRegistry)context);
        beanDefinitionReader.loadBeanDefinitions("/net/shibboleth/saml/profile/context/logic/attribute-registry-service.xml");
        context.refresh();
        return (ReloadableService)context.getBean(ReloadableService.class);
    }

    @Test
    public void testSimpleMatch() throws ResolverException {
        EntityAttributesPredicate.Candidate tag = new EntityAttributesPredicate.Candidate("zorkmids", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        tag.setValues((Collection)CollectionSupport.singletonList((Object)"10"));
        EntityAttributesPredicate predicate = new EntityAttributesPredicate((Collection)CollectionSupport.singletonList((Object)tag));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.fooEntityID)));
        Assert.assertTrue((boolean)predicate.test(this.getEntity(this.barEntityID)));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.bazEntityID)));
    }

    @Test
    public void testMultiLevelMatch() throws ResolverException {
        EntityAttributesPredicate.Candidate tag1 = new EntityAttributesPredicate.Candidate("http://macedir.org/entity-category", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        tag1.setValues((Collection)CollectionSupport.singletonList((Object)"http://refeds.org/category/research-and-scholarship"));
        EntityAttributesPredicate.Candidate tag2 = new EntityAttributesPredicate.Candidate("urn:oasis:names:tc:SAML:profiles:subject-id:req", "urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        tag2.setValues((Collection)CollectionSupport.singletonList((Object)"none"));
        EntityAttributesPredicate predicate = new EntityAttributesPredicate((Collection)CollectionSupport.listOf((Object)tag1, (Object)tag2), false, true);
        Assert.assertTrue((boolean)predicate.test(this.getEntity(this.fooEntityID)));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.barEntityID)));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.bazEntityID)));
    }

    @Test
    public void testSimpleMatchMapped() throws ResolverException {
        EntityAttributesPredicate.Candidate tag = new EntityAttributesPredicate.Candidate("zorkmids");
        tag.setValues((Collection)CollectionSupport.singletonList((Object)"10"));
        MappedEntityAttributesPredicate predicate = new MappedEntityAttributesPredicate((Collection)CollectionSupport.singletonList((Object)tag));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.fooEntityID)));
        Assert.assertTrue((boolean)predicate.test(this.getEntity(this.barEntityID)));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.bazEntityID)));
    }

    @Test
    public void testMultiLevelMappedMatch() throws ResolverException {
        EntityAttributesPredicate.Candidate tag1 = new EntityAttributesPredicate.Candidate("http://macedir.org/entity-category");
        tag1.setValues((Collection)CollectionSupport.singletonList((Object)"http://refeds.org/category/research-and-scholarship"));
        EntityAttributesPredicate.Candidate tag2 = new EntityAttributesPredicate.Candidate("subject-id-req");
        tag2.setValues((Collection)CollectionSupport.singletonList((Object)"none"));
        MappedEntityAttributesPredicate predicate = new MappedEntityAttributesPredicate((Collection)CollectionSupport.listOf((Object)tag1, (Object)tag2), false, true);
        Assert.assertTrue((boolean)predicate.test(this.getEntity(this.fooEntityID)));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.barEntityID)));
        Assert.assertFalse((boolean)predicate.test(this.getEntity(this.bazEntityID)));
    }
}

