/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.security.factory;

import java.net.URL;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import net.shibboleth.shared.spring.security.factory.PKCS11PrivateKeyFactoryBean;
import org.testng.Assert;
import org.testng.annotations.Test;

public class PKCS11PrivateKeyFactoryBeanTest {
    @Test
    public void testPrerequisites() throws Exception {
        Provider p = Security.getProvider("SunPKCS11");
        Assert.assertNotNull((Object)p);
    }

    @Test(enabled=false)
    public void testSoftHSM() throws Exception {
        URL configResource = this.getClass().getResource("/net/shibboleth/shared/spring/security/factory/PKCS11PrivateKeyFactoryBean-softhsm.cfg");
        String configFile = configResource.getFile();
        PKCS11PrivateKeyFactoryBean fac = new PKCS11PrivateKeyFactoryBean();
        fac.setPkcs11Config(configFile);
        fac.setKeyPassword("1234");
        fac.setKeyAlias("key2048");
        PrivateKey key = fac.getObject();
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((String)key.getAlgorithm(), (String)"RSA");
    }
}

