/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.security.factory;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.Assert;
import org.testng.annotations.Test;

@ContextConfiguration(value={"X509CertificateFactoryBean-config.xml"})
public class X509CertificateFactoryBeanTest
extends AbstractTestNGSpringContextTests {
    @Test
    public void testFactory() {
        assert (this.applicationContext != null);
        Object bean = this.applicationContext.getBean("certificate");
        Assert.assertNotNull((Object)bean);
        Assert.assertTrue((boolean)(bean instanceof X509Certificate));
        X509Certificate cert = (X509Certificate)bean;
        PublicKey pubkey = cert.getPublicKey();
        Assert.assertNotNull((Object)pubkey);
        Assert.assertTrue((boolean)(pubkey instanceof RSAPublicKey));
        RSAPublicKey rsaKey = (RSAPublicKey)pubkey;
        Assert.assertTrue((rsaKey.getModulus().bitLength() == 2048 ? 1 : 0) != 0);
    }
}

