/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.service;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.service.ServiceableComponent;
import org.slf4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;

public abstract class AbstractServiceableComponent<T>
extends AbstractIdentifiableInitializableComponent
implements ServiceableComponent<T>,
ApplicationContextAware {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractServiceableComponent.class);
    @Nullable
    private ApplicationContext applicationContext;
    @Nonnull
    private final ReentrantReadWriteLock serviceLock = new ReentrantReadWriteLock(false);

    public void setApplicationContext(@Nullable ApplicationContext context) {
        this.checkSetterPreconditions();
        this.applicationContext = context;
    }

    @Nullable
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    @Nonnull
    public abstract T getComponent();

    public void pinComponent() {
        this.serviceLock.readLock().lock();
    }

    public void unpinComponent() {
        this.serviceLock.readLock().unlock();
    }

    @Override
    public void close() {
        this.unpinComponent();
    }

    public void unloadComponent() {
        if (null == this.applicationContext) {
            this.log.debug("Component '{}': Component already unloaded", (Object)this.getId());
            return;
        }
        ConfigurableApplicationContext oldContext = null;
        this.log.debug("Component '{}': Component unload called", (Object)this.getId());
        try {
            this.log.trace("Component '{}': Queueing for write lock", (Object)this.getId());
            this.serviceLock.writeLock().lock();
            this.log.trace("Component '{}': Got write lock", (Object)this.getId());
            oldContext = (ConfigurableApplicationContext)this.applicationContext;
            this.applicationContext = null;
        }
        finally {
            this.serviceLock.writeLock().unlock();
        }
        if (null != oldContext) {
            this.log.debug("Component '{}': Closing the appcontext", (Object)this.getId());
            oldContext.close();
        }
        this.destroy();
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.applicationContext == null) {
            throw new ComponentInitializationException(this.getId() + ": Application context not set");
        }
        if (!(this.applicationContext instanceof ConfigurableApplicationContext)) {
            throw new ComponentInitializationException(this.getId() + ": Application context did not implement ConfigurableApplicationContext");
        }
    }

    protected void doDestroy() {
        this.unloadComponent();
        super.doDestroy();
    }
}

