/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.spring.service;

import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.NonnullFunction;
import net.shibboleth.shared.service.ServiceException;
import net.shibboleth.shared.spring.service.AbstractServiceableComponent;
import net.shibboleth.shared.spring.service.impl.SpringServiceableComponent;
import org.springframework.context.ApplicationContext;

public class ClassBasedServiceStrategy<T>
implements NonnullFunction<ApplicationContext, AbstractServiceableComponent<T>> {
    @Nonnull
    private final Class<T> serviceClaz;

    public ClassBasedServiceStrategy(@ParameterName(name="serviceableClaz") @Nonnull Class<T> serviceableClaz) {
        this.serviceClaz = (Class)Constraint.isNotNull(serviceableClaz, (String)"Serviceable Class cannot be null");
    }

    @Nonnull
    public AbstractServiceableComponent<T> apply(@Nullable ApplicationContext appContext) {
        if (appContext == null) {
            throw new ServiceException("Input ApplicationContext was null");
        }
        Collection components = appContext.getBeansOfType(this.serviceClaz).values();
        if (components.size() == 0) {
            throw new ServiceException("Reload did not produce any bean of type " + this.serviceClaz.getName());
        }
        if (components.size() > 1) {
            throw new ServiceException("Reload produced " + components.size() + " ServiceableComponents");
        }
        Object value = components.iterator().next();
        assert (value != null);
        SpringServiceableComponent result = new SpringServiceableComponent(value);
        result.setApplicationContext(appContext);
        try {
            result.initialize();
        }
        catch (ComponentInitializationException e) {
            throw new ServiceException("Unable to initialize service type " + this.serviceClaz.getName() + " from " + appContext.getDisplayName(), (Exception)((Object)e));
        }
        return result;
    }
}

