/*
 * This file is part of the OWL API.
 *
 * The contents of this file are subject to the LGPL License, Version 3.0.
 *
 * Copyright (C) 2011, The University of Manchester
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 *
 *
 * Alternatively, the contents of this file may be used under the terms of the Apache License, Version 2.0
 * in which case, the provisions of the Apache License Version 2.0 are applicable instead of those above.
 *
 * Copyright 2011, University of Manchester
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.semanticweb.owlapi.reasoner;

/** An enumeration that denotes various types of inference task. Each inference
 * task has a name that is associated with it - reasoners may use these names
 * when reporting progress.
 * 
 * @author Matthew Horridge, The University of Manchester, Bio-Health
 *         Informatics Group, Date: 04-Jul-2010 */
public enum InferenceType {
    /** Denotes the computation of the class hierarchy. */
    CLASS_HIERARCHY("class hierarchy"),
    /** Denotes the computation of the object property hierarchy. */
    OBJECT_PROPERTY_HIERARCHY("object property hierarchy"),
    /** Denotes the computation of the data property hierarchy. */
    DATA_PROPERTY_HIERARCHY("data property hierarchy"),
    /** Denotes the computation of the direct types of individuals for each
     * individual in the signature of the imports closure of the root ontology. */
    CLASS_ASSERTIONS("class assertions"),
    /** Denotes the computation of relationships between individuals in the
     * signature of the imports closure of the root ontology. */
    OBJECT_PROPERTY_ASSERTIONS("object property assertions"),
    /** Denotes the computation of relationships between individuals and data
     * property values for each individual in the signature of the imports
     * closure of the root ontology. */
    DATA_PROPERTY_ASSERTIONS("data property assertions"),
    /** Denotes the computation of individuals that are interpreted as the same
     * object for each individual in the imports closure of the root ontology. */
    SAME_INDIVIDUAL("same individuals"),
    /** Denotes the computation of sets of individuals that are different from
     * each individual in the signature of the imports closure of the root
     * ontology. */
    DIFFERENT_INDIVIDUALS("different individuals"),
    /** Denotes the computation of sets of classes that are disjoint for each
     * class in the signature of the imports closure of the root ontology. */
    DISJOINT_CLASSES("disjoint classes");
    private final String name;

    InferenceType(String name) {
        this.name = name;
    }

    @Override
    public String toString() {
        return name;
    }
}
