/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.semanticweb.owlapi.io.OWLParserFactory;

public class OWLParserFactoryRegistry {
    private static final OWLParserFactoryRegistry instance = new OWLParserFactoryRegistry();
    private final List<OWLParserFactory> parserFactories = new ArrayList<OWLParserFactory>(10);

    private OWLParserFactoryRegistry() {
    }

    public static OWLParserFactoryRegistry getInstance() {
        return instance;
    }

    public void clearParserFactories() {
        this.parserFactories.clear();
    }

    public List<OWLParserFactory> getParserFactories() {
        return Collections.unmodifiableList(this.parserFactories);
    }

    public void registerParserFactory(OWLParserFactory parserFactory) {
        this.parserFactories.add(0, parserFactory);
    }

    public void unregisterParserFactory(OWLParserFactory parserFactory) {
        this.parserFactories.remove(parserFactory);
    }
}

