/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cli;

import java.util.AbstractMap;
import net.sourceforge.plantuml.cli.Arity;
import net.sourceforge.plantuml.cli.CliFlag;
import net.sourceforge.plantuml.utils.Peeker;

public class CliFlagValued {
    private final CliFlag flag;
    private final Object value;

    private CliFlagValued(CliFlag flag2, Object value) {
        this.flag = flag2;
        this.value = value;
    }

    public CliFlag getFlag() {
        return this.flag;
    }

    public Object getValue() {
        return this.value;
    }

    public String toString() {
        return (Object)((Object)this.flag) + ":=" + this.value;
    }

    public static CliFlagValued parse(Peeker<String> peeker) {
        String tmp = peeker.peek(0);
        for (CliFlag flag2 : CliFlag.values()) {
            String tail;
            if (!flag2.match(tmp)) continue;
            Arity type = flag2.getType();
            if (type == Arity.BOOLEAN) {
                return new CliFlagValued(flag2, Boolean.TRUE);
            }
            if (type == Arity.SINGLE_VALUE) {
                peeker.jump();
                String s = peeker.peek(0);
                return new CliFlagValued(flag2, s);
            }
            if (type == Arity.KEY_VALUE) {
                String v;
                String k;
                String s = peeker.peek(0).substring(2);
                int eqIndex = s.indexOf(61);
                if (eqIndex == -1) {
                    k = s;
                    v = null;
                } else {
                    k = s.substring(0, eqIndex);
                    v = s.substring(eqIndex + 1);
                }
                return new CliFlagValued(flag2, new AbstractMap.SimpleImmutableEntry<String, String>(k, v));
            }
            if (type != Arity.KEY_OPTIONAL_COLON_VALUE) continue;
            int colon = tmp.indexOf(58);
            String value = colon < 0 ? null : ((tail = tmp.substring(colon + 1)).isEmpty() ? null : tail);
            return new CliFlagValued(flag2, value);
        }
        return null;
    }
}

