/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import net.sourceforge.pmd.internal.util.PredicateUtil;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.ModifierOwner;
import net.sourceforge.pmd.lang.java.ast.ReturnScopeNode;
import net.sourceforge.pmd.lang.java.metrics.internal.AtfdBaseVisitor;
import net.sourceforge.pmd.lang.java.metrics.internal.ClassFanOutVisitor;
import net.sourceforge.pmd.lang.java.metrics.internal.CognitiveComplexityVisitor;
import net.sourceforge.pmd.lang.java.metrics.internal.CycloVisitor;
import net.sourceforge.pmd.lang.java.metrics.internal.NPathMetricCalculator;
import net.sourceforge.pmd.lang.java.metrics.internal.NcssVisitor;
import net.sourceforge.pmd.lang.java.rule.internal.JavaRuleUtil;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JVariableSymbol;
import net.sourceforge.pmd.lang.metrics.Metric;
import net.sourceforge.pmd.lang.metrics.MetricOption;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.metrics.MetricsUtil;
import org.apache.commons.lang3.mutable.MutableInt;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class JavaMetrics {
    public static final Metric<JavaNode, Integer> ACCESS_TO_FOREIGN_DATA = Metric.of(JavaMetrics::computeAtfd, JavaMetrics.isJavaNode(), (String)"Access To Foreign Data", (String[])new String[]{"ATFD"});
    public static final Metric<ASTExecutableDeclaration, Integer> CYCLO = Metric.of(JavaMetrics::computeCyclo, JavaMetrics.asMethodOrCtor(), (String)"Cyclomatic Complexity", (String[])new String[]{"Cyclo"});
    public static final Metric<ASTExecutableDeclaration, Integer> COGNITIVE_COMPLEXITY = Metric.of(JavaMetrics::computeCognitive, JavaMetrics.asMethodOrCtor(), (String)"Cognitive Complexity", (String[])new String[]{"CognitiveComp"});
    public static final Metric<JavaNode, Integer> FAN_OUT = Metric.of(JavaMetrics::computeFanOut, JavaMetrics.isJavaNode(), (String)"Fan-Out", (String[])new String[]{"CFO"});
    public static final Metric<JavaNode, Integer> LINES_OF_CODE = Metric.of(JavaMetrics::computeLoc, JavaMetrics.isJavaNode(), (String)"Lines of code", (String[])new String[]{"LOC"});
    public static final Metric<JavaNode, Integer> NCSS = Metric.of(JavaMetrics::computeNcss, JavaMetrics.isJavaNode(), (String)"Non-commenting source statements", (String[])new String[]{"NCSS"});
    public static final Metric<ReturnScopeNode, Long> NPATH_COMP = Metric.of(JavaMetrics::computeNpath, (Function)NodeStream.asInstanceOf(ReturnScopeNode.class, (Class[])new Class[0]), (String)"NPath Complexity", (String[])new String[]{"NPath"});
    @Deprecated
    public static final Metric<ASTExecutableDeclaration, BigInteger> NPATH = Metric.of(JavaMetrics::computeNpath, JavaMetrics.asMethodOrCtor(), (String)"NPath Complexity (deprecated)", (String[])new String[]{"NPath"});
    public static final Metric<ASTTypeDeclaration, Integer> NUMBER_OF_ACCESSORS = Metric.of(JavaMetrics::computeNoam, JavaMetrics.asClass(PredicateUtil.always()), (String)"Number of accessor methods", (String[])new String[]{"NOAM"});
    public static final Metric<ASTTypeDeclaration, Integer> NUMBER_OF_PUBLIC_FIELDS = Metric.of(JavaMetrics::computeNopa, JavaMetrics.asClass(PredicateUtil.always()), (String)"Number of public attributes", (String[])new String[]{"NOPA"});
    public static final Metric<ASTTypeDeclaration, Double> TIGHT_CLASS_COHESION = Metric.of(JavaMetrics::computeTcc, JavaMetrics.asClass(it -> !it.isInterface()), (String)"Tight Class Cohesion", (String[])new String[]{"TCC"});
    public static final Metric<ASTTypeDeclaration, Integer> WEIGHED_METHOD_COUNT = Metric.of(JavaMetrics::computeWmc, JavaMetrics.asClass(it -> !it.isInterface()), (String)"Weighed Method Count", (String[])new String[]{"WMC"});
    public static final Metric<ASTTypeDeclaration, Double> WEIGHT_OF_CLASS = Metric.of(JavaMetrics::computeWoc, JavaMetrics.asClass(it -> !it.isInterface()), (String)"Weight Of Class", (String[])new String[]{"WOC"});

    private JavaMetrics() {
    }

    private static Function<Node, JavaNode> isJavaNode() {
        return n -> n instanceof JavaNode ? (JavaNode)n : null;
    }

    private static Function<Node, @Nullable ASTExecutableDeclaration> asMethodOrCtor() {
        return n -> n instanceof ASTExecutableDeclaration ? (ASTExecutableDeclaration)n : null;
    }

    private static <T extends Node> Function<Node, T> filterMapNode(Class<? extends T> klass, Predicate<? super T> pred) {
        return n -> n.asStream().filterIs(klass).filter(pred).first();
    }

    private static Function<Node, ASTTypeDeclaration> asClass(Predicate<? super ASTTypeDeclaration> pred) {
        return JavaMetrics.filterMapNode(ASTTypeDeclaration.class, pred);
    }

    private static int computeNoam(ASTTypeDeclaration node, MetricOptions ignored) {
        return node.getDeclarations().filterIs(ASTMethodDeclaration.class).filter(JavaRuleUtil::isGetterOrSetter).count();
    }

    private static int computeNopa(ASTTypeDeclaration node, MetricOptions ignored) {
        return node.getDeclarations().filterIs(ASTFieldDeclaration.class).filter(it -> it.hasVisibility(ModifierOwner.Visibility.V_PUBLIC)).flatMap(rec$ -> ((ASTFieldDeclaration)rec$).getVarIds()).count();
    }

    private static int computeNcss(JavaNode node, MetricOptions options) {
        MutableInt result = new MutableInt(0);
        node.acceptVisitor(new NcssVisitor(options, node), result);
        return result.getValue();
    }

    private static int computeLoc(JavaNode node, MetricOptions ignored) {
        FileLocation loc = node.getTextDocument().toLocation(node.getTextRegion());
        return 1 + loc.getEndLine() - loc.getStartLine();
    }

    private static int computeCyclo(JavaNode node, MetricOptions options) {
        MutableInt counter = new MutableInt(0);
        node.acceptVisitor(new CycloVisitor(options, node), counter);
        return counter.getValue();
    }

    private static BigInteger computeNpath(ASTExecutableDeclaration node, MetricOptions ignored) {
        return BigInteger.valueOf(NPathMetricCalculator.computeNpath(node));
    }

    private static long computeNpath(ReturnScopeNode node, MetricOptions ignored) {
        return NPathMetricCalculator.computeNpath(node);
    }

    private static int computeCognitive(JavaNode node, MetricOptions ignored) {
        CognitiveComplexityVisitor.State state = new CognitiveComplexityVisitor.State(node);
        node.acceptVisitor(CognitiveComplexityVisitor.INSTANCE, state);
        return state.getComplexity();
    }

    private static int computeWmc(ASTTypeDeclaration node, MetricOptions options) {
        return (int)MetricsUtil.computeStatistics(CYCLO, node.getOperations(), (MetricOptions)options).getSum();
    }

    private static double computeTcc(ASTTypeDeclaration node, MetricOptions ignored) {
        List<Set<String>> usagesByMethod = JavaMetrics.attributeAccessesByMethod(node);
        int numPairs = JavaMetrics.numMethodsRelatedByAttributeAccess(usagesByMethod);
        int maxPairs = JavaMetrics.maxMethodPairs(usagesByMethod.size());
        if (maxPairs == 0) {
            return 0.0;
        }
        return (double)numPairs / (double)maxPairs;
    }

    private static List<Set<String>> attributeAccessesByMethod(ASTTypeDeclaration type) {
        ArrayList<Set<String>> map = new ArrayList<Set<String>>();
        JClassSymbol typeSym = type.getSymbol();
        for (ASTMethodDeclaration decl : type.getDeclarations(ASTMethodDeclaration.class)) {
            HashSet attrs = new HashSet();
            decl.descendants().crossFindBoundaries().filterIs(ASTAssignableExpr.ASTNamedReferenceExpr.class).forEach(it -> {
                JVariableSymbol sym = it.getReferencedSym();
                if (sym instanceof JFieldSymbol && typeSym.equals(((JFieldSymbol)sym).getEnclosingClass())) {
                    attrs.add(sym.getSimpleName());
                }
            });
            map.add(attrs);
        }
        return map;
    }

    private static int numMethodsRelatedByAttributeAccess(List<Set<String>> usagesByMethod) {
        int methodCount = usagesByMethod.size();
        int pairs = 0;
        if (methodCount > 1) {
            for (int i = 0; i < methodCount - 1; ++i) {
                for (int j = i + 1; j < methodCount; ++j) {
                    if (Collections.disjoint((Collection)usagesByMethod.get(i), (Collection)usagesByMethod.get(j))) continue;
                    ++pairs;
                }
            }
        }
        return pairs;
    }

    private static int maxMethodPairs(int methods) {
        return methods * (methods - 1) / 2;
    }

    private static int computeAtfd(JavaNode node, MetricOptions ignored) {
        MutableInt result = new MutableInt(0);
        node.acceptVisitor(new AtfdBaseVisitor(), result);
        return result.getValue();
    }

    private static double computeWoc(ASTTypeDeclaration node, MetricOptions ignored) {
        NodeStream methods = node.getDeclarations().filterIs(ASTMethodDeclaration.class).filter(it -> !it.hasVisibility(ModifierOwner.Visibility.V_PRIVATE));
        int notSetter = methods.filter(it -> !JavaRuleUtil.isGetterOrSetter(it)).count();
        int total = methods.count();
        if (total == 0) {
            return 0.0;
        }
        return (double)notSetter / (double)total;
    }

    private static int computeFanOut(JavaNode node, MetricOptions options) {
        HashSet cfo = new HashSet();
        node.acceptVisitor(ClassFanOutVisitor.getInstance(options), cfo);
        return cfo.size();
    }

    public static enum ClassFanOutOption implements MetricOption
    {
        INCLUDE_JAVA_LANG("includeJavaLang");

        private final String vName;

        private ClassFanOutOption(String valueName) {
            this.vName = valueName;
        }

        public String valueName() {
            return this.vName;
        }
    }

    public static enum CycloOption implements MetricOption
    {
        IGNORE_BOOLEAN_PATHS("ignoreBooleanPaths"),
        CONSIDER_ASSERT("considerAssert");

        private final String vName;

        private CycloOption(String valueName) {
            this.vName = valueName;
        }

        public String valueName() {
            return this.vName;
        }
    }

    public static enum NcssOption implements MetricOption
    {
        COUNT_IMPORTS("countImports");

        private final String vName;

        private NcssOption(String valueName) {
            this.vName = valueName;
        }

        public String valueName() {
            return this.vName;
        }
    }
}

