/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTClassType;
import net.sourceforge.pmd.lang.java.ast.ASTEnumConstant;
import net.sourceforge.pmd.lang.java.ast.ASTFieldAccess;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTInitializer;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.ASTTypeBody;
import net.sourceforge.pmd.lang.java.ast.ASTTypeExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableId;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JAccessibleElementSymbol;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JElementSymbol;
import net.sourceforge.pmd.lang.java.symbols.JFieldSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.lang.java.symbols.table.JSymbolTable;
import net.sourceforge.pmd.lang.java.symbols.table.ScopeInfo;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChain;
import net.sourceforge.pmd.lang.java.symbols.table.coreimpl.ShadowChainIterator;
import net.sourceforge.pmd.lang.java.types.JMethodSig;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.util.AssertionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class UnnecessaryFullyQualifiedNameRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Boolean> REPORT_METHODS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"reportStaticMethods").desc("Report unnecessary static method qualifiers like in `Collections.emptyList()`, if the method is imported or inherited.")).defaultValue((Object)true)).build();
    private static final PropertyDescriptor<Boolean> REPORT_FIELDS = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.booleanProperty((String)"reportStaticFields").desc("Report unnecessary static field qualifiers like in `Math.PI`, if the field is imported or inherited.")).defaultValue((Object)true)).build();

    public UnnecessaryFullyQualifiedNameRule() {
        super(ASTClassType.class, new Class[0]);
        this.definePropertyDescriptor(REPORT_METHODS);
        this.definePropertyDescriptor(REPORT_FIELDS);
    }

    public Object visit(ASTClassType deepest, Object data) {
        ASTClassType nextParent;
        ScopeInfo newBestReason;
        if (deepest.getQualifier() != null) {
            return data;
        }
        ASTClassType next = deepest;
        ScopeInfo bestReason = null;
        if (next.isFullyQualified()) {
            bestReason = UnnecessaryFullyQualifiedNameRule.typeMeansSame(next);
        }
        while (bestReason != null && this.segmentIsIrrelevant(next) && next.getParent() instanceof ASTClassType && (newBestReason = UnnecessaryFullyQualifiedNameRule.typeMeansSame(nextParent = (ASTClassType)next.getParent())) != null) {
            bestReason = newBestReason;
            next = nextParent;
        }
        if (next.getParent() instanceof ASTTypeExpression) {
            ASTFieldAccess fieldAccess;
            ScopeInfo reasonForFieldInScope;
            JavaNode opa = (JavaNode)((JavaNode)next.getParent()).getParent();
            if (((Boolean)this.getProperty(REPORT_METHODS)).booleanValue() && opa instanceof ASTMethodCall) {
                ASTMethodCall methodCall = (ASTMethodCall)opa;
                if (methodCall.getExplicitTypeArguments() == null && UnnecessaryFullyQualifiedNameRule.methodProbablyMeansSame(methodCall)) {
                    String simpleName = UnnecessaryFullyQualifiedNameRule.formatMemberName(next, methodCall.getMethodType().getSymbol());
                    String unnecessary = this.produceQualifier(deepest, next, true);
                    this.asCtx(data).addViolation((Node)next, new Object[]{unnecessary, simpleName, ""});
                    return null;
                }
            } else if (((Boolean)this.getProperty(REPORT_FIELDS)).booleanValue() && opa instanceof ASTFieldAccess && (reasonForFieldInScope = UnnecessaryFullyQualifiedNameRule.fieldMeansSame(fieldAccess = (ASTFieldAccess)opa)) != null && !UnnecessaryFullyQualifiedNameRule.isForwardReference(fieldAccess)) {
                String simpleName = UnnecessaryFullyQualifiedNameRule.formatMemberName(next, fieldAccess.getReferencedSym());
                String reasonToString = UnnecessaryFullyQualifiedNameRule.unnecessaryReasonWrapper(reasonForFieldInScope);
                String unnecessary = this.produceQualifier(deepest, next, true);
                this.asCtx(data).addViolation((Node)next, new Object[]{unnecessary, simpleName, reasonToString});
                return null;
            }
        }
        if (bestReason != null) {
            String simpleName = next.getSimpleName();
            String reasonToString = UnnecessaryFullyQualifiedNameRule.unnecessaryReasonWrapper(bestReason);
            String unnecessary = this.produceQualifier(deepest, next, false);
            this.asCtx(data).addViolation((Node)next, new Object[]{unnecessary, simpleName, reasonToString});
        }
        return null;
    }

    private String produceQualifier(ASTClassType startIncluded, ASTClassType stopExcluded, boolean includeLast) {
        ASTClassType nextSimpleName;
        StringBuilder sb = new StringBuilder();
        if (startIncluded.isFullyQualified()) {
            sb.append(startIncluded.getTypeMirror().getSymbol().getPackageName());
        }
        for (nextSimpleName = startIncluded; nextSimpleName != stopExcluded; nextSimpleName = (ASTClassType)nextSimpleName.getParent()) {
            sb.append('.').append(nextSimpleName.getSimpleName());
        }
        if (includeLast) {
            if (sb.length() == 0) {
                return nextSimpleName.getSimpleName();
            }
            sb.append('.').append(nextSimpleName.getSimpleName());
        }
        return sb.toString();
    }

    private boolean segmentIsIrrelevant(ASTClassType type) {
        return type.getTypeArguments() == null && type.getDeclaredAnnotations().isEmpty();
    }

    private static @Nullable ScopeInfo typeMeansSame(@NonNull ASTClassType typeNode) {
        JTypeDeclSymbol sym = typeNode.getTypeMirror().getSymbol();
        if (sym == null || sym.isUnresolved()) {
            return null;
        }
        JSymbolTable symTable = typeNode.getSymbolTable();
        if (symTable.variables().resolveFirst(sym.getSimpleName()) != null) {
            return null;
        }
        return UnnecessaryFullyQualifiedNameRule.fieldOrTypeMeansSame(sym, typeNode.getSymbolTable(), JSymbolTable::types, (s, t) -> s.equals(t.getSymbol()));
    }

    private static boolean methodProbablyMeansSame(ASTMethodCall call) {
        List<JMethodSig> accessibleMethods = call.getSymbolTable().methods().resolve(call.getMethodName());
        if (accessibleMethods.isEmpty() || call.getOverloadSelectionInfo().isFailed()) {
            return false;
        }
        JClassSymbol methodOwner = call.getMethodType().getSymbol().getEnclosingClass();
        for (JMethodSig m : accessibleMethods) {
            if (m.getSymbol().getEnclosingClass().equals(methodOwner)) continue;
            return false;
        }
        return true;
    }

    private static ScopeInfo fieldMeansSame(ASTFieldAccess field) {
        JFieldSymbol sym = field.getReferencedSym();
        if (sym == null || sym.isUnresolved()) {
            return null;
        }
        return UnnecessaryFullyQualifiedNameRule.fieldOrTypeMeansSame(sym, field.getSymbolTable(), JSymbolTable::variables, (s, t) -> s.equals(t.getSymbol()));
    }

    private static <S extends JElementSymbol, T> ScopeInfo fieldOrTypeMeansSame(@NonNull S originalSym, JSymbolTable symTable, Function<JSymbolTable, ShadowChain<T, ScopeInfo>> shadowChainGetter, BiPredicate<S, T> areEqual) {
        ShadowChainIterator<T, ScopeInfo> iter = shadowChainGetter.apply(symTable).iterateResults(originalSym.getSimpleName());
        if (iter.hasNext()) {
            iter.next();
            List<T> results = iter.getResults();
            if (results.size() == 1 && areEqual.test(originalSym, (S)results.get(0))) {
                return iter.getScopeTag();
            }
            return null;
        }
        return null;
    }

    private static String formatMemberName(ASTClassType qualifier, JAccessibleElementSymbol call) {
        JClassSymbol methodOwner = call.getEnclosingClass();
        if (methodOwner != null && !methodOwner.equals(qualifier.getTypeMirror().getSymbol())) {
            return methodOwner.getSimpleName() + "::" + call.getSimpleName();
        }
        return call.getSimpleName();
    }

    private static String unnecessaryReasonWrapper(ScopeInfo scopeInfo) {
        return " because it is " + UnnecessaryFullyQualifiedNameRule.unnecessaryReason(scopeInfo);
    }

    private static String unnecessaryReason(ScopeInfo scopeInfo) {
        switch (scopeInfo) {
            case JAVA_LANG: {
                return "declared in java.lang";
            }
            case SAME_PACKAGE: 
            case SAME_FILE: {
                return "declared in the same package";
            }
            case SINGLE_IMPORT: 
            case IMPORT_ON_DEMAND: {
                return "imported in this file";
            }
            case INHERITED: {
                return "inherited by an enclosing type";
            }
            case ENCLOSING_TYPE_MEMBER: 
            case ENCLOSING_TYPE: {
                return "declared in an enclosing type";
            }
        }
        throw AssertionUtil.shouldNotReachHere((String)("unknown constant ScopeInfo: " + (Object)((Object)scopeInfo)));
    }

    private static boolean isPartOfStaticInitialization(ASTBodyDeclaration decl) {
        return decl instanceof ASTFieldDeclaration && ((ASTFieldDeclaration)decl).isStatic() || decl instanceof ASTInitializer && ((ASTInitializer)decl).isStatic() || decl instanceof ASTEnumConstant;
    }

    private static boolean isForwardReference(ASTFieldAccess fieldAccess) {
        JFieldSymbol referencedSym = fieldAccess.getReferencedSym();
        if (referencedSym == null || referencedSym.isUnresolved()) {
            return false;
        }
        ASTVariableId fieldDecl = (ASTVariableId)referencedSym.tryGetNode();
        if (fieldDecl == null || !fieldDecl.isStatic()) {
            return false;
        }
        ASTBodyDeclaration enclosing = (ASTBodyDeclaration)fieldAccess.ancestors(ASTBodyDeclaration.class).first();
        if (UnnecessaryFullyQualifiedNameRule.isPartOfStaticInitialization(enclosing) && ((JavaNode)enclosing.getParent()).getParent() == fieldDecl.getEnclosingType()) {
            if (JavaAstUtils.isInStaticCtx(fieldDecl) && !JavaAstUtils.isInStaticCtx(fieldAccess)) {
                return false;
            }
            int declIndex = ((JavaNode)fieldDecl.ancestors().filter(it -> it.getParent() instanceof ASTTypeBody).firstOrThrow()).getIndexInParent();
            int accessIndex = enclosing.getIndexInParent();
            return accessIndex <= declIndex;
        }
        return false;
    }
}

