/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTCatchClause;
import net.sourceforge.pmd.lang.java.ast.ASTThrowStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;

public class ExceptionAsFlowControlRule
extends AbstractJavaRulechainRule {
    public ExceptionAsFlowControlRule() {
        super(ASTThrowStatement.class, new Class[0]);
    }

    public Object visit(ASTThrowStatement node, Object data) {
        JTypeMirror thrownType = node.getExpr().getTypeMirror();
        JavaNode parent = (JavaNode)node.getParent();
        while (!(parent instanceof ASTBodyDeclaration)) {
            if (parent instanceof ASTCatchClause) {
                parent = (JavaNode)((JavaNode)parent.getParent()).getParent();
                continue;
            }
            if (parent instanceof ASTTryStatement) {
                for (ASTCatchClause catchClause : ((ASTTryStatement)parent).getCatchClauses()) {
                    if (!catchClause.getParameter().getAllExceptionTypes().any(it -> thrownType.isSubtypeOf(it.getTypeMirror()))) continue;
                    if (JavaAstUtils.isJustRethrowException(catchClause)) break;
                    this.asCtx(data).addViolation((Node)catchClause, new Object[]{node.getReportLocation().getStartLine()});
                    return null;
                }
            }
            parent = (JavaNode)parent.getParent();
        }
        return null;
    }
}

