/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.jbehave;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.jbehave.ThucydidesJUnitStories;
import org.codehaus.plexus.util.StringUtils;

public class ThucydidesJUnitStory
extends ThucydidesJUnitStories {
    public ThucydidesJUnitStory() {
        this.findStoriesCalled(this.storynamesDerivedFromClassName());
    }

    public ThucydidesJUnitStory(EnvironmentVariables environmentVariables) {
        super(environmentVariables);
        this.findStoriesCalled(this.storynamesDerivedFromClassName());
    }

    protected ThucydidesJUnitStory(Configuration configuration) {
        super(configuration);
        this.findStoriesCalled(this.storynamesDerivedFromClassName());
    }

    public void run() throws Throwable {
        super.run();
    }

    protected String storynamesDerivedFromClassName() {
        List<String> storyNames = this.getStoryNameCandidatesFrom(this.startingWithUpperCase(this.simpleClassName()), this.startingWithLowerCase(this.simpleClassName()), this.underscoredTestName());
        return org.apache.commons.lang3.StringUtils.join(storyNames, (String)";");
    }

    private List<String> getStoryNameCandidatesFrom(String ... storyNameCandidates) {
        ArrayList storyNames = Lists.newArrayList();
        for (String storyName : storyNameCandidates) {
            if (!storyNames.isEmpty()) continue;
            this.addIfPresent(storyNames, "/" + storyName + ".story");
            this.addIfPresent(storyNames, "stories/" + storyName + ".story");
        }
        if (storyNames.isEmpty()) {
            for (String storyName : storyNameCandidates) {
                storyNames.add("**/" + storyName + ".story");
            }
        }
        return storyNames;
    }

    private String startingWithUpperCase(String storyName) {
        return StringUtils.capitalise((String)storyName);
    }

    private String startingWithLowerCase(String storyName) {
        return StringUtils.lowercaseFirstLetter((String)storyName);
    }

    private void addIfPresent(List<String> storyNames, String storyNameCandidate) {
        if (Thread.currentThread().getContextClassLoader().getResource(storyNameCandidate) != null) {
            storyNames.add(storyNameCandidate);
        }
    }

    private String simpleClassName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    private String underscoredTestName() {
        return Inflector.getInstance().of(this.simpleClassName()).withUnderscores().toString();
    }
}

