/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.jbehave.converters;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thucydides.jbehave.converters.YearMonthConverter;
import org.jbehave.core.steps.ParameterConverters;
import org.joda.time.YearMonth;

public class YearMonthListConverter
implements ParameterConverters.ParameterConverter {
    public static final String DEFAULT_LIST_SEPARATOR = ",";
    private final YearMonthConverter yearMonthConverter = new YearMonthConverter();
    private final String valueSeparator;

    public YearMonthListConverter() {
        this(DEFAULT_LIST_SEPARATOR);
    }

    public YearMonthListConverter(String valueSeparator) {
        this.valueSeparator = valueSeparator;
    }

    public boolean accept(Type type) {
        if (type instanceof ParameterizedType) {
            Type rawType = this.rawType(type);
            Type argumentType = this.argumentType(type);
            return List.class.isAssignableFrom((Class)rawType) && this.yearMonthConverter.accept(argumentType);
        }
        return false;
    }

    public Object convertValue(String value, Type type) {
        System.out.println(type);
        Type argumentType = this.argumentType(type);
        List values = ParameterConverters.trim(Arrays.asList(value.split(this.valueSeparator)));
        ArrayList<YearMonth> times = new ArrayList<YearMonth>();
        for (String string : values) {
            times.add((YearMonth)this.yearMonthConverter.convertValue(string, argumentType));
        }
        return times;
    }

    private Type rawType(Type type) {
        return ((ParameterizedType)type).getRawType();
    }

    private Type argumentType(Type type) {
        return ((ParameterizedType)type).getActualTypeArguments()[0];
    }
}

