/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.scale.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.time4j.PlainDate;
import net.time4j.base.GregorianDate;
import net.time4j.base.ResourceLoader;
import net.time4j.format.platform.SimpleFormatter;
import net.time4j.scale.LeapSecondProvider;
import net.time4j.scale.LeapSeconds;

public final class DefaultLeapSecondProviderSPI
implements LeapSecondProvider {
    private final String source;
    private final PlainDate expires;
    private final Map<GregorianDate, Integer> table;

    public DefaultLeapSecondProviderSPI() {
        PlainDate plainDate = PlainDate.axis().getMinimum();
        this.table = new LinkedHashMap<GregorianDate, Integer>(50);
        String string = LeapSeconds.PATH_TO_LEAPSECONDS;
        URI uRI = ResourceLoader.getInstance().locate("core", LeapSecondProvider.class, string);
        InputStream inputStream = ResourceLoader.getInstance().load(uRI, true);
        if (inputStream == null) {
            inputStream = LeapSecondProvider.class.getClassLoader().getResourceAsStream(string);
        }
        if (inputStream != null) {
            this.source = uRI.toString();
            SimpleFormatter<PlainDate> simpleFormatter = SimpleFormatter.ofDatePattern("yyyy-MM-dd", Locale.ROOT);
            try {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "US-ASCII"));
                while ((string2 = bufferedReader.readLine()) != null) {
                    int n;
                    int n2;
                    Integer n3;
                    int n4;
                    String string3;
                    if (string2.startsWith("#")) continue;
                    if (string2.startsWith("@expires=")) {
                        String string4 = string2.substring(9);
                        plainDate = (PlainDate)simpleFormatter.parse(string4);
                        continue;
                    }
                    int n5 = string2.indexOf(44);
                    Boolean bl = null;
                    if (n5 == -1) {
                        string3 = string2.trim();
                        bl = Boolean.TRUE;
                    } else {
                        string3 = string2.substring(0, n5).trim();
                        String string5 = string2.substring(n5 + 1).trim();
                        if (string5.length() == 1) {
                            n4 = string5.charAt(0);
                            if (n4 == 43) {
                                bl = Boolean.TRUE;
                            } else if (n4 == 45) {
                                bl = Boolean.FALSE;
                            }
                        }
                        if (bl == null) {
                            throw new IllegalStateException("Missing leap second sign.");
                        }
                    }
                    if ((n3 = this.table.put(PlainDate.of(n2 = Integer.parseInt(string3.substring(0, 4)), n4 = Integer.parseInt(string3.substring(5, 7)), n = Integer.parseInt(string3.substring(8, 10))), bl != false ? 1 : -1)) == null) continue;
                    throw new IllegalStateException("Duplicate leap second event found.");
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new AssertionError((Object)unsupportedEncodingException);
            }
            catch (IllegalStateException illegalStateException) {
                throw illegalStateException;
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace(System.err);
                }
            }
        }
        this.source = "";
        System.err.println("Warning: File \"" + string + "\" not found.");
        this.expires = plainDate;
    }

    @Override
    public Map<GregorianDate, Integer> getLeapSecondTable() {
        return Collections.unmodifiableMap(this.table);
    }

    @Override
    public boolean supportsNegativeLS() {
        return true;
    }

    @Override
    public GregorianDate getDateOfEvent(int n, int n2, int n3) {
        return PlainDate.of(n, n2, n3);
    }

    @Override
    public GregorianDate getDateOfExpiration() {
        return this.expires;
    }

    public String toString() {
        return this.source;
    }
}

