/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.NameUtil;
import org.identityconnectors.framework.common.objects.OperationalAttributes;

public class Attribute {
    private final String name;
    private final List<Object> value;

    Attribute(String name, List<Object> value) {
        if (StringUtil.isBlank(name)) {
            throw new IllegalArgumentException("Name must not be blank!");
        }
        if (OperationalAttributes.PASSWORD_NAME.equals(name) || OperationalAttributes.CURRENT_PASSWORD_NAME.equals(name)) {
            if (value == null || value.size() != 1) {
                throw new IllegalArgumentException("Must be a single value.");
            }
            if (!(value.get(0) instanceof GuardedString)) {
                throw new IllegalArgumentException("Password value must be an instance of GuardedString");
            }
        }
        this.name = name;
        this.value = value == null ? null : CollectionUtil.newReadOnlyList(value);
    }

    public String getName() {
        return this.name;
    }

    public List<Object> getValue() {
        return this.value == null ? null : Collections.unmodifiableList(this.value);
    }

    public boolean is(String name) {
        return NameUtil.namesEqual(this.name, name);
    }

    public final int hashCode() {
        return NameUtil.nameHashCode(this.name);
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        bld.append("Attribute: ");
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("Name", this.getName());
        map.put("Value", this.getValue());
        bld.append(map);
        return bld.toString();
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Attribute other = (Attribute)obj;
        if (!this.is(other.name)) {
            return false;
        }
        return CollectionUtil.equals(this.value, other.value);
    }
}

