/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.QualifiedUid;
import org.identityconnectors.framework.common.objects.SortKey;
import org.identityconnectors.framework.common.serializer.SerializerUtil;

public final class OperationOptionsBuilder {
    private final Map<String, Object> options;

    public OperationOptionsBuilder() {
        this.options = new HashMap<String, Object>();
    }

    public OperationOptionsBuilder(OperationOptions options) {
        Map operationOptionsClone;
        Assertions.nullCheck(options, "options");
        this.options = operationOptionsClone = (Map)SerializerUtil.cloneObject(options.getOptions());
    }

    public OperationOptionsBuilder setOption(String name, Object value) {
        Assertions.blankCheck(name, "name");
        this.options.put(name, value);
        return this;
    }

    public OperationOptionsBuilder setAttributesToGet(String ... attrNames) {
        Assertions.nullCheck(attrNames, "attrNames");
        this.options.put("ATTRS_TO_GET", attrNames);
        return this;
    }

    public OperationOptionsBuilder setAttributesToGet(Collection<String> attrNames) {
        Assertions.nullCheck(attrNames, "attrNames");
        String[] attrs = new String[attrNames.size()];
        attrs = attrNames.toArray(attrs);
        this.options.put("ATTRS_TO_GET", attrs);
        return this;
    }

    public OperationOptionsBuilder setReturnDefaultAttributes(Boolean flag) {
        Assertions.nullCheck(flag, "flag");
        this.options.put("RETURN_DEFAULT_ATTRIBUTES", flag);
        return this;
    }

    public OperationOptionsBuilder setRunWithPassword(GuardedString password) {
        Assertions.nullCheck(password, "password");
        this.options.put("RUN_WITH_PASSWORD", password);
        return this;
    }

    public OperationOptionsBuilder setRunAsUser(String user) {
        Assertions.nullCheck(user, "user");
        this.options.put("RUN_AS_USER", user);
        return this;
    }

    public OperationOptionsBuilder setScope(String scope) {
        Assertions.nullCheck(scope, "scope");
        this.options.put("SCOPE", scope);
        return this;
    }

    public OperationOptionsBuilder setContainer(QualifiedUid container) {
        Assertions.nullCheck(container, "container");
        this.options.put("CONTAINER", container);
        return this;
    }

    public OperationOptionsBuilder setPagedResultsCookie(String pagedResultsCookie) {
        Assertions.nullCheck(pagedResultsCookie, "pagedResultsCookie");
        this.options.put("PAGED_RESULTS_COOKIE", pagedResultsCookie);
        return this;
    }

    public OperationOptionsBuilder setPagedResultsOffset(Integer pagedResultsOffset) {
        Assertions.nullCheck(pagedResultsOffset, "pagedResultsOffset");
        this.options.put("PAGED_RESULTS_OFFSET", pagedResultsOffset);
        return this;
    }

    public OperationOptionsBuilder setPageSize(Integer pageSize) {
        Assertions.nullCheck(pageSize, "pageSize");
        this.options.put("PAGE_SIZE", pageSize);
        return this;
    }

    public OperationOptionsBuilder setSortKeys(List<SortKey> sortKeys) {
        Assertions.nullCheck(sortKeys, "sortKeys");
        this.options.put("SORT_KEYS", sortKeys.toArray(new SortKey[sortKeys.size()]));
        return this;
    }

    public OperationOptionsBuilder setSortKeys(SortKey ... sortKeys) {
        Assertions.nullCheck(sortKeys, "sortKeys");
        this.options.put("SORT_KEYS", sortKeys);
        return this;
    }

    public OperationOptionsBuilder setAllowPartialResults(boolean allowPartialResults) {
        this.options.put("ALLOW_PARTIAL_RESULTS", allowPartialResults);
        return this;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public OperationOptions build() {
        return new OperationOptions(this.options);
    }
}

