/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.api.operations.AuthenticationApiOp;
import org.identityconnectors.framework.api.operations.CreateApiOp;
import org.identityconnectors.framework.api.operations.DeleteApiOp;
import org.identityconnectors.framework.api.operations.GetApiOp;
import org.identityconnectors.framework.api.operations.ResolveUsernameApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnConnectorApiOp;
import org.identityconnectors.framework.api.operations.ScriptOnResourceApiOp;
import org.identityconnectors.framework.api.operations.SearchApiOp;
import org.identityconnectors.framework.api.operations.SyncApiOp;
import org.identityconnectors.framework.api.operations.UpdateApiOp;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;
import org.identityconnectors.framework.common.objects.ObjectClassInfoBuilder;
import org.identityconnectors.framework.common.objects.OperationOptionInfo;
import org.identityconnectors.framework.common.objects.OperationOptionInfoBuilder;
import org.identityconnectors.framework.common.objects.Schema;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.operations.SPIOperation;
import org.identityconnectors.framework.spi.operations.SchemaOp;
import org.identityconnectors.framework.spi.operations.ScriptOnConnectorOp;
import org.identityconnectors.framework.spi.operations.ScriptOnResourceOp;
import org.identityconnectors.framework.spi.operations.TestOp;

public final class SchemaBuilder {
    private final Set<ObjectClassInfo> declaredObjectClasses = new HashSet<ObjectClassInfo>();
    private final Set<OperationOptionInfo> declaredOperationOptions = new HashSet<OperationOptionInfo>();
    private final Map<Class<? extends APIOperation>, Set<ObjectClassInfo>> supportedObjectClassesByOperation = new HashMap<Class<? extends APIOperation>, Set<ObjectClassInfo>>();
    private final Map<Class<? extends APIOperation>, Set<OperationOptionInfo>> supportedOptionsByOperation = new HashMap<Class<? extends APIOperation>, Set<OperationOptionInfo>>();
    private final Set<Class<? extends APIOperation>> defaultSupportedOperations;

    public SchemaBuilder(Class<? extends Connector> connectorClass) {
        Assertions.nullCheck(connectorClass, "connectorClass");
        this.defaultSupportedOperations = FrameworkUtil.getDefaultSupportedOperations(connectorClass);
    }

    private boolean objectClassOperation(Class<? extends APIOperation> op) {
        return AuthenticationApiOp.class.equals(op) || CreateApiOp.class.equals(op) || DeleteApiOp.class.equals(op) || GetApiOp.class.equals(op) || ResolveUsernameApiOp.class.equals(op) || SearchApiOp.class.equals(op) || SyncApiOp.class.equals(op) || UpdateApiOp.class.equals(op);
    }

    private boolean operationOptionOperation(Class<? extends APIOperation> op) {
        return AuthenticationApiOp.class.equals(op) || CreateApiOp.class.equals(op) || DeleteApiOp.class.equals(op) || GetApiOp.class.equals(op) || ResolveUsernameApiOp.class.equals(op) || ScriptOnConnectorApiOp.class.equals(op) || ScriptOnResourceApiOp.class.equals(op) || SearchApiOp.class.equals(op) || SyncApiOp.class.equals(op) || UpdateApiOp.class.equals(op);
    }

    public void defineObjectClass(ObjectClassInfo info) {
        Assertions.nullCheck(info, "info");
        if (this.declaredObjectClasses.contains(info)) {
            throw new IllegalStateException("ObjectClass already defined: " + info.getType());
        }
        this.declaredObjectClasses.add(info);
        for (Class<? extends APIOperation> op : this.defaultSupportedOperations) {
            if (!this.objectClassOperation(op)) continue;
            Set<ObjectClassInfo> oclasses = this.supportedObjectClassesByOperation.get(op);
            if (oclasses == null) {
                oclasses = new HashSet<ObjectClassInfo>();
                this.supportedObjectClassesByOperation.put(op, oclasses);
            }
            oclasses.add(info);
        }
    }

    public void defineObjectClass(ObjectClassInfo objectClassInfo, Class<? extends SPIOperation> ... operations) {
        if (operations.length > 0) {
            Assertions.nullCheck(objectClassInfo, "objectClassInfo");
            if (this.declaredObjectClasses.contains(objectClassInfo)) {
                throw new IllegalStateException("ObjectClass already defined: " + objectClassInfo.getType());
            }
            this.declaredObjectClasses.add(objectClassInfo);
            for (Class<? extends SPIOperation> spi : operations) {
                if (SchemaOp.class.equals(spi) || ScriptOnConnectorOp.class.equals(spi) || ScriptOnResourceOp.class.equals(spi) || TestOp.class.equals(spi)) continue;
                Set<Class<? extends APIOperation>> apiOperations = FrameworkUtil.spi2apis(spi);
                apiOperations.retainAll(this.defaultSupportedOperations);
                for (Class<? extends APIOperation> api : apiOperations) {
                    if (!this.objectClassOperation(api)) continue;
                    Set<ObjectClassInfo> oclasses = this.supportedObjectClassesByOperation.get(api);
                    if (oclasses == null) {
                        oclasses = new HashSet<ObjectClassInfo>();
                        this.supportedObjectClassesByOperation.put(api, oclasses);
                    }
                    oclasses.add(objectClassInfo);
                }
            }
        } else {
            this.defineObjectClass(objectClassInfo);
        }
    }

    public void defineOperationOption(OperationOptionInfo info) {
        Assertions.nullCheck(info, "info");
        if (this.declaredOperationOptions.contains(info)) {
            throw new IllegalStateException("OperationOption already defined: " + info.getName());
        }
        this.declaredOperationOptions.add(info);
        for (Class<? extends APIOperation> op : this.defaultSupportedOperations) {
            if (!this.operationOptionOperation(op)) continue;
            Set<OperationOptionInfo> oclasses = this.supportedOptionsByOperation.get(op);
            if (oclasses == null) {
                oclasses = new HashSet<OperationOptionInfo>();
                this.supportedOptionsByOperation.put(op, oclasses);
            }
            oclasses.add(info);
        }
    }

    public void defineOperationOption(OperationOptionInfo operationOptionInfo, Class<? extends SPIOperation> ... operations) {
        if (operations.length > 0) {
            Assertions.nullCheck(operationOptionInfo, "info");
            if (this.declaredOperationOptions.contains(operationOptionInfo)) {
                throw new IllegalStateException("OperationOption already defined: " + operationOptionInfo.getName());
            }
            this.declaredOperationOptions.add(operationOptionInfo);
            for (Class<? extends SPIOperation> spi : operations) {
                if (SchemaOp.class.equals(spi) || TestOp.class.equals(spi)) continue;
                Set<Class<? extends APIOperation>> apiOperations = FrameworkUtil.spi2apis(spi);
                apiOperations.retainAll(this.defaultSupportedOperations);
                for (Class<? extends APIOperation> api : apiOperations) {
                    if (!this.operationOptionOperation(api)) continue;
                    Set<OperationOptionInfo> oclasses = this.supportedOptionsByOperation.get(api);
                    if (oclasses == null) {
                        oclasses = new HashSet<OperationOptionInfo>();
                        this.supportedOptionsByOperation.put(api, oclasses);
                    }
                    oclasses.add(operationOptionInfo);
                }
            }
        } else {
            this.defineOperationOption(operationOptionInfo);
        }
    }

    public void defineObjectClass(String type, Set<AttributeInfo> attrInfo) {
        ObjectClassInfoBuilder bld = new ObjectClassInfoBuilder();
        bld.setType(type);
        bld.addAllAttributeInfo(attrInfo);
        ObjectClassInfo obj = bld.build();
        this.defineObjectClass(obj);
    }

    public void defineOperationOption(String optionName, Class<?> type) {
        OperationOptionInfoBuilder bld = new OperationOptionInfoBuilder();
        bld.setName(optionName);
        bld.setType(type);
        OperationOptionInfo info = bld.build();
        this.defineOperationOption(info);
    }

    public void addSupportedObjectClass(Class<? extends SPIOperation> op, ObjectClassInfo def) {
        Assertions.nullCheck(op, "op");
        Assertions.nullCheck(def, "def");
        Set<Class<? extends APIOperation>> apis = FrameworkUtil.spi2apis(op);
        apis.retainAll(this.defaultSupportedOperations);
        if (!this.declaredObjectClasses.contains(def)) {
            throw new IllegalArgumentException("ObjectClass " + def.getType() + " not defined in schema.");
        }
        for (Class<? extends APIOperation> api : apis) {
            if (!this.objectClassOperation(api)) continue;
            Set<ObjectClassInfo> infos = this.supportedObjectClassesByOperation.get(api);
            if (infos == null) {
                throw new IllegalArgumentException("Operation " + op.getName() + " not implement by connector.");
            }
            if (infos.contains(def)) {
                throw new IllegalArgumentException("ObjectClass " + def.getType() + " already supported for operation " + op.getName());
            }
            infos.add(def);
        }
    }

    public void removeSupportedObjectClass(Class<? extends SPIOperation> op, ObjectClassInfo def) {
        Assertions.nullCheck(op, "op");
        Assertions.nullCheck(def, "def");
        Set<Class<? extends APIOperation>> apis = FrameworkUtil.spi2apis(op);
        if (!this.declaredObjectClasses.contains(def)) {
            throw new IllegalArgumentException("ObjectClass " + def.getType() + " not defined in schema.");
        }
        for (Class<? extends APIOperation> api : apis) {
            if (!this.objectClassOperation(api)) continue;
            if (this.defaultSupportedOperations.contains(api)) {
                Set<ObjectClassInfo> infos = this.supportedObjectClassesByOperation.get(api);
                if (null == infos || !infos.contains(def)) {
                    throw new IllegalArgumentException("ObjectClass " + def.getType() + " already removed for operation " + op.getName());
                }
                infos.remove(def);
                continue;
            }
            throw new IllegalArgumentException("Operation " + op.getName() + " not implement by connector.");
        }
    }

    public void addSupportedOperationOption(Class<? extends SPIOperation> op, OperationOptionInfo def) {
        Assertions.nullCheck(op, "op");
        Assertions.nullCheck(def, "def");
        Set<Class<? extends APIOperation>> apis = FrameworkUtil.spi2apis(op);
        apis.retainAll(this.defaultSupportedOperations);
        if (!this.declaredOperationOptions.contains(def)) {
            throw new IllegalArgumentException("OperationOption " + def.getName() + " not defined in schema.");
        }
        for (Class<? extends APIOperation> api : apis) {
            if (!this.operationOptionOperation(api)) continue;
            Set<OperationOptionInfo> infos = this.supportedOptionsByOperation.get(api);
            if (infos == null) {
                throw new IllegalArgumentException("Operation " + op.getName() + " not implement by connector.");
            }
            if (infos.contains(def)) {
                throw new IllegalArgumentException("OperationOption " + def.getName() + " already supported for operation " + op.getName());
            }
            infos.add(def);
        }
    }

    public void removeSupportedOperationOption(Class<? extends SPIOperation> op, OperationOptionInfo def) {
        Assertions.nullCheck(op, "op");
        Assertions.nullCheck(def, "def");
        Set<Class<? extends APIOperation>> apis = FrameworkUtil.spi2apis(op);
        if (!this.declaredOperationOptions.contains(def)) {
            throw new IllegalArgumentException("OperationOption " + def.getName() + " not defined in schema.");
        }
        for (Class<? extends APIOperation> api : apis) {
            if (!this.operationOptionOperation(api)) continue;
            if (this.defaultSupportedOperations.contains(api)) {
                Set<OperationOptionInfo> infos = this.supportedOptionsByOperation.get(api);
                if (null == infos || !infos.contains(def)) {
                    throw new IllegalArgumentException("OperationOption " + def.getName() + " already removed for operation " + op.getName());
                }
                infos.remove(def);
                continue;
            }
            throw new IllegalArgumentException("Operation " + op.getName() + " not implement by connector.");
        }
    }

    public void clearSupportedObjectClassesByOperation() {
        for (Set<ObjectClassInfo> values : this.supportedObjectClassesByOperation.values()) {
            values.clear();
        }
    }

    public void clearSupportedOptionsByOperation() {
        for (Set<OperationOptionInfo> values : this.supportedOptionsByOperation.values()) {
            values.clear();
        }
    }

    public Schema build() {
        if (this.declaredObjectClasses.isEmpty()) {
            throw new IllegalStateException("Must be at least one ObjectClassInfo object!");
        }
        return new Schema(this.declaredObjectClasses, this.declaredOperationOptions, this.supportedObjectClassesByOperation, this.supportedOptionsByOperation);
    }
}

