/*
 * Decompiled with CFR 0.152.
 */
package net.vrallev.java.ecc;

import djb.Curve25519;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.util.Arrays;
import net.i2p.crypto.eddsa.EdDSAEngine;
import net.i2p.crypto.eddsa.EdDSAPrivateKey;
import net.i2p.crypto.eddsa.EdDSAPublicKey;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveSpec;
import net.i2p.crypto.eddsa.spec.EdDSANamedCurveTable;
import net.i2p.crypto.eddsa.spec.EdDSAParameterSpec;
import net.i2p.crypto.eddsa.spec.EdDSAPrivateKeySpec;
import net.i2p.crypto.eddsa.spec.EdDSAPublicKeySpec;
import net.vrallev.java.ecc.KeyHolder;

public class Ecc25519Helper {
    private final KeyHolder mKeyHolder;
    private final EdDSAEngine mEdDSAEngine;

    static MessageDigest getSha256Digest() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            digest.reset();
            return digest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    static MessageDigest getSha512Digest() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-512");
            digest.reset();
            return digest;
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }

    public Ecc25519Helper() {
        this((KeyHolder)null);
    }

    public Ecc25519Helper(byte[] privateKey) {
        this(new KeyHolder(privateKey));
    }

    public Ecc25519Helper(KeyHolder keyHolder) {
        this.mKeyHolder = keyHolder;
        this.mEdDSAEngine = new EdDSAEngine(Ecc25519Helper.getSha512Digest());
    }

    public byte[] diffieHellman() {
        return this.diffieHellman(this.mKeyHolder.getPrivateKey(), this.mKeyHolder.getPublicKeyDiffieHellman());
    }

    public byte[] diffieHellman(byte[] privateKey, byte[] publicKey) {
        byte[] sharedSecret = new byte[32];
        Curve25519.curve(sharedSecret, privateKey, publicKey);
        return Ecc25519Helper.getSha256Digest().digest(sharedSecret);
    }

    public byte[] sign(byte[] message) {
        return this.signWithoutClamp(message, this.mKeyHolder.getPrivateKey(), this.mKeyHolder.getPublicKeySignature());
    }

    public byte[] sign(byte[] message, byte[] privateKey, byte[] publicKey) {
        privateKey = Arrays.copyOf(privateKey, privateKey.length);
        Curve25519.clamp(privateKey);
        return this.signWithoutClamp(message, privateKey, publicKey);
    }

    protected byte[] signWithoutClamp(byte[] message, byte[] privateKey, byte[] publicKey) {
        try {
            EdDSAPrivateKeySpec edDSAPrivateKeySpec = new EdDSAPrivateKeySpec(privateKey, (EdDSAParameterSpec)EdDSANamedCurveTable.getByName((String)"ed25519-sha-512"));
            this.mEdDSAEngine.initSign((PrivateKey)new EdDSAPrivateKey(edDSAPrivateKeySpec));
            this.mEdDSAEngine.update(message);
            return this.mEdDSAEngine.sign();
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e);
        }
        catch (SignatureException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public boolean isValidSignature(byte[] message, byte[] signature) {
        return this.isValidSignature(message, signature, this.mKeyHolder.getPublicKeySignature());
    }

    public boolean isValidSignature(byte[] message, byte[] signature, byte[] publicKey) {
        try {
            EdDSANamedCurveSpec spec = EdDSANamedCurveTable.getByName((String)"ed25519-sha-512");
            EdDSAPublicKeySpec edDSAPublicKeySpec = new EdDSAPublicKeySpec(publicKey, (EdDSAParameterSpec)spec);
            EdDSAPublicKey edDSAPublicKey = new EdDSAPublicKey(edDSAPublicKeySpec);
            this.mEdDSAEngine.initVerify((PublicKey)edDSAPublicKey);
            this.mEdDSAEngine.update(message);
            return this.mEdDSAEngine.verify(signature);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public KeyHolder getKeyHolder() {
        return this.mKeyHolder;
    }
}

