/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.ant;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.wasdev.wlp.ant.AbstractTask;

public abstract class FeatureManagerTask
extends AbstractTask {
    protected String cmd;
    protected String name;
    protected List<Feature> features = new ArrayList<Feature>();

    public void addFeature(Feature feature) {
        this.features.add(feature);
    }

    @Override
    protected void initTask() {
        super.initTask();
        if (isWindows) {
            this.cmd = "\"" + this.installDir + "\\bin\\installUtility.bat\"";
            this.processBuilder.environment().put("EXIT_ALL", "1");
        } else {
            this.cmd = this.installDir + "/bin/installUtility";
        }
        Properties sysp = System.getProperties();
        String javaHome = sysp.getProperty("java.home");
        this.processBuilder.directory(this.installDir);
        this.processBuilder.environment().put("JAVA_HOME", javaHome);
        this.processBuilder.redirectErrorStream(true);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<Feature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<Feature> features) {
        this.features = features;
    }

    public static class Feature {
        private String feature;

        public String getFeature() {
            return this.feature;
        }

        public void addText(String txt) {
            this.feature = txt;
        }
    }

    public static enum ReturnCode {
        OK(0),
        BAD_ARGUMENT(20),
        RUNTIME_EXCEPTION(21),
        ALREADY_EXISTS(22),
        BAD_FEATURE_DEFINITION(23),
        MISSING_CONTENT(24),
        IO_FAILURE(25),
        PRODUCT_EXT_NOT_FOUND(26),
        PRODUCT_EXT_NOT_DEFINED(27),
        PRODUCT_EXT_NO_FEATURES_FOUND(28),
        NOT_VALID_FOR_CURRENT_PRODUCT(29);

        final int val;

        private ReturnCode(int val) {
            this.val = val;
        }

        public int getValue() {
            return this.val;
        }
    }
}

