/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.ant;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import net.wasdev.wlp.ant.AbstractTask;
import org.apache.tools.ant.BuildException;

public class ServerTask
extends AbstractTask {
    private String operation;
    private String timeout;
    private String wlp;
    private static final String START_MESSAGE_CODE = "CWWKF0011I";
    private static final String STOP_MESSAGE_CODE = "CWWKE0036I";
    private static final long SERVER_START_TIMEOUT_DEFAULT = 30000L;
    private static final long SERVER_STOP_TIMEOUT_DEFAULT = 30000L;
    private boolean clean = false;
    private String resultProperty;
    private File archive;
    private String include;
    private String template;
    private String os;

    @Override
    protected void initTask() {
        super.initTask();
        if (isWindows) {
            this.wlp = "\"" + this.installDir + "\\bin\\server.bat\"";
            this.processBuilder.environment().put("EXIT_ALL", "1");
        } else {
            this.wlp = this.installDir + "/bin/server";
        }
        Properties sysp = System.getProperties();
        String javaHome = sysp.getProperty("java.home");
        this.processBuilder.directory(this.installDir);
        this.processBuilder.environment().put("JAVA_HOME", javaHome);
        this.processBuilder.redirectErrorStream(true);
    }

    public void execute() {
        block14: {
            this.initTask();
            if (this.getRuntimeConfigurableWrapper().getAttributeMap().get("id") == null && (this.operation == null || this.operation.length() <= 0)) {
                throw new BuildException(MessageFormat.format(messages.getString("error.server.operation.validate"), "operation"));
            }
            if (this.operation != null) {
                try {
                    if ("create".equals(this.operation)) {
                        this.doCreate();
                        break block14;
                    }
                    if ("run".equals(this.operation)) {
                        this.doRun();
                        break block14;
                    }
                    if ("start".equals(this.operation)) {
                        this.doStart();
                        break block14;
                    }
                    if ("stop".equals(this.operation)) {
                        this.doStop();
                        break block14;
                    }
                    if ("status".equals(this.operation)) {
                        this.doStatus();
                        break block14;
                    }
                    if ("debug".equals(this.operation)) {
                        this.doDebug();
                        break block14;
                    }
                    if ("package".equals(this.operation)) {
                        this.doPackage();
                        break block14;
                    }
                    if ("dump".equals(this.operation)) {
                        this.doDump();
                        break block14;
                    }
                    if ("javadump".equals(this.operation)) {
                        this.doJavaDump();
                        break block14;
                    }
                    throw new BuildException("Unsupported operation: " + this.operation);
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
    }

    private void doStart() throws Exception {
        if (!this.serverConfigDir.exists()) {
            this.log(MessageFormat.format(messages.getString("info.server.create"), this.serverName));
            this.doCreate();
        }
        List<String> command = this.getInitialCommand(this.operation);
        this.addCleanOption(command);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), ReturnCode.OK.getValue(), ReturnCode.REDUNDANT_ACTION_STATUS.getValue());
        long startTimeout = 30000L;
        if (this.timeout != null && !this.timeout.equals("")) {
            startTimeout = Long.valueOf(this.timeout);
        }
        this.validateServerStarted(this.getLogFile(), startTimeout);
    }

    private void validateServerStarted(File outputFile, long startTimeout) throws Exception {
        boolean serverStarted = false;
        this.log("Waiting up to " + startTimeout / 1000L + " seconds for server confirmation:  " + START_MESSAGE_CODE.toString() + " to be found in " + outputFile);
        try {
            String startMessage = this.waitForStringInLog(START_MESSAGE_CODE, startTimeout, outputFile);
            serverStarted = startMessage != null;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        if (!serverStarted) {
            throw new BuildException(messages.getString("error.server.fail"));
        }
    }

    private void doRun() throws Exception {
        if (!this.serverConfigDir.exists()) {
            this.log(MessageFormat.format(messages.getString("info.server.create"), this.serverName));
            this.doCreate();
        }
        List<String> command = this.getInitialCommand(this.operation);
        this.addCleanOption(command);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        final AtomicBoolean shutdown = new AtomicBoolean(false);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                shutdown.set(true);
                List stopCommand = ServerTask.this.getInitialCommand("stop");
                ServerTask.this.processBuilder.command(stopCommand);
                try {
                    Process p = ServerTask.this.processBuilder.start();
                    p.waitFor();
                }
                catch (Exception e) {
                    ServerTask.this.log("Error stopping server", e, 1);
                }
            }
        });
        int exitCode = this.getReturnCode(p, this.processBuilder.command().toString());
        if (!shutdown.get() && exitCode != ReturnCode.OK.getValue()) {
            throw new BuildException(MessageFormat.format(messages.getString("error.invoke.command"), this.processBuilder.command().toString(), exitCode, ReturnCode.OK.getValue()));
        }
    }

    private void doStop() throws Exception {
        List<String> command = this.getInitialCommand(this.operation);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), ReturnCode.OK.getValue(), ReturnCode.REDUNDANT_ACTION_STATUS.getValue());
    }

    private void doStatus() throws Exception {
        List<String> command = this.getInitialCommand(this.operation);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        int exitCode = this.getReturnCode(p, this.processBuilder.command().toString());
        if (this.resultProperty == null) {
            this.resultProperty = "wlp." + this.serverName + ".status";
        }
        this.getProject().setUserProperty(this.resultProperty, String.valueOf(exitCode));
    }

    private void doDump() throws Exception {
        List<String> command = this.getInitialCommand(this.operation);
        this.addArchiveOption(command);
        this.addIncludeOption(command);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), ReturnCode.OK.getValue());
    }

    private void doJavaDump() throws Exception {
        List<String> command = this.getInitialCommand(this.operation);
        this.addIncludeOption(command);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), ReturnCode.OK.getValue());
    }

    private void doPackage() throws Exception {
        List<String> command = this.getInitialCommand(this.operation);
        this.addArchiveOption(command);
        this.addIncludeOption(command);
        this.addOsOption(command);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), ReturnCode.OK.getValue());
    }

    private void doCreate() throws Exception {
        List<String> command = this.getInitialCommand("create");
        if (this.template != null) {
            command.add("--template=" + this.template);
        }
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), ReturnCode.OK.getValue());
    }

    private void doDebug() throws Exception {
        List<String> command = this.getInitialCommand(this.operation);
        this.addCleanOption(command);
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), ReturnCode.OK.getValue());
    }

    private List<String> getInitialCommand(String operation) {
        ArrayList<String> commands = new ArrayList<String>();
        commands.add(this.wlp);
        commands.add(operation);
        if (this.serverName != null && !this.serverName.equals("")) {
            commands.add(this.serverName);
        }
        return commands;
    }

    private void addArchiveOption(List<String> command) {
        if (this.archive != null) {
            if (this.archive.isDirectory()) {
                throw new BuildException("The archive attribute must specify a file");
            }
            command.add("--archive=" + this.archive);
        }
    }

    private void addIncludeOption(List<String> command) {
        if (this.include != null) {
            command.add("--include=" + this.include);
        }
    }

    private void addOsOption(List<String> command) {
        if (this.os != null) {
            command.add("--os=" + this.os);
        }
    }

    private void addCleanOption(List<String> command) {
        if (this.clean) {
            command.add("--clean");
        }
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public File getArchive() {
        return this.archive;
    }

    public void setArchive(File archive) {
        this.archive = archive;
    }

    public boolean isClean() {
        return this.clean;
    }

    public void setClean(boolean clean) {
        this.clean = clean;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getOs() {
        return this.os;
    }

    public void setOs(String os) {
        this.os = os;
    }

    public String getResultProperty() {
        return this.resultProperty;
    }

    public void setResultProperty(String resultProperty) {
        this.resultProperty = resultProperty;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public static enum ReturnCode {
        OK(0),
        REDUNDANT_ACTION_STATUS(1),
        SERVER_NOT_EXIST_STATUS(2),
        SERVER_ACTIVE_STATUS(3),
        SERVER_INACTIVE_STATUS(4),
        BAD_ARGUMENT(20),
        ERROR_SERVER_STOP(21),
        ERROR_SERVER_START(22),
        LOCATION_EXCEPTION(23),
        LAUNCH_EXCEPTION(24),
        RUNTIME_EXCEPTION(25),
        UNKNOWN_EXCEPTION(26),
        PROCESS_CLIENT_EXCEPTION(27),
        ERROR_SERVER_PACKAGE(28),
        ERROR_SERVER_DUMP(29),
        ERROR_SERVER_ATTACH(30);

        final int val;

        private ReturnCode(int val) {
            this.val = val;
        }

        public int getValue() {
            return this.val;
        }
    }
}

