/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.ant;

import java.text.MessageFormat;
import java.util.ArrayList;
import net.wasdev.wlp.ant.FeatureManagerTask;
import org.apache.tools.ant.BuildException;

public class UninstallFeatureTask
extends FeatureManagerTask {
    public void execute() {
        if ((this.name == null || this.name.isEmpty()) && this.features.isEmpty()) {
            throw new BuildException(MessageFormat.format(messages.getString("error.parameter.empty"), "name"));
        }
        this.initTask();
        try {
            this.doUninstall();
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void doUninstall() throws Exception {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.cmd);
        command.add("uninstall");
        command.add("--noPrompts");
        if (this.name != null && !this.name.isEmpty()) {
            String[] names;
            for (String featureName : names = this.name.trim().split("\\s*,\\s*")) {
                if (this.name.isEmpty()) continue;
                command.add(featureName);
            }
        }
        if (!this.features.isEmpty()) {
            for (FeatureManagerTask.Feature feature : this.features) {
                command.add(feature.getFeature());
            }
        }
        this.processBuilder.command(command);
        Process p = this.processBuilder.start();
        this.checkReturnCode(p, this.processBuilder.command().toString(), FeatureManagerTask.ReturnCode.OK.getValue());
    }
}

