/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.ant.install;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import net.wasdev.wlp.ant.install.InstallLibertyTask;
import net.wasdev.wlp.ant.install.InstallUtils;
import net.wasdev.wlp.ant.install.Installer;
import net.wasdev.wlp.ant.install.LibertyInfo;
import net.wasdev.wlp.ant.install.LibertyYaml;
import net.wasdev.wlp.ant.install.Version;
import org.apache.tools.ant.BuildException;

public class WasDevInstaller
implements Installer {
    private static final String LICENSE_REGEX = "D/N:\\s*(.*?)\\s*\\<";
    private String url;
    private String licenseCode;
    private String version;
    private String type;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getLicenseCode() {
        return this.licenseCode;
    }

    public void setLicenseCode(String licenseCode) {
        this.licenseCode = licenseCode;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void install(InstallLibertyTask task) throws Exception {
        Version baseVersion;
        if (this.url == null) {
            this.url = "https://public.dhe.ibm.com/ibmdl/export/pub/software/websphere/wasdev/downloads/wlp/index.yml";
        }
        if (this.type == null) {
            this.type = this.licenseCode == null ? "webProfile7" : "webProfile6";
        }
        File cacheDir = new File(task.getCacheDir());
        InstallUtils.createDirectory(cacheDir);
        URL ymlURL = new URL(this.url);
        File ymlFile = new File(cacheDir, InstallUtils.getFile(ymlURL));
        task.downloadFile(ymlURL, ymlFile);
        List<LibertyInfo> versions = LibertyYaml.parse(ymlFile);
        if (this.version == null) {
            Iterator<LibertyInfo> iterator = versions.iterator();
            while (iterator.hasNext()) {
                LibertyInfo info = iterator.next();
                if (info.getVersion().getMajor() <= 2000) continue;
                iterator.remove();
            }
            baseVersion = Version.parseVersion("+", true);
        } else {
            baseVersion = Version.parseVersion(this.version, true);
        }
        LibertyInfo selectedVersion = InstallUtils.selectVersion(baseVersion, versions);
        File versionCacheDir = new File(task.getCacheDir(), selectedVersion.getVersion().toString());
        InstallUtils.createDirectory(versionCacheDir);
        String uri = this.getRuntimeURI(selectedVersion);
        if (uri.endsWith(".jar")) {
            task.checkLicenseSet();
            URL licenseURL = new URL(selectedVersion.getLicenseUri());
            File licenseFile = new File(versionCacheDir, InstallUtils.getFile(licenseURL));
            task.downloadFile(licenseURL, licenseFile);
            task.checkLicense(InstallUtils.getLicenseCode(licenseFile, LICENSE_REGEX));
            URL libertyURL = new URL(uri);
            File libertyFile = new File(versionCacheDir, InstallUtils.getFile(libertyURL));
            task.downloadFile(libertyURL, libertyFile);
            task.installLiberty(libertyFile);
        } else {
            URL libertyURL = new URL(uri);
            File libertyFile = new File(versionCacheDir, InstallUtils.getFile(libertyURL));
            task.downloadFile(libertyURL, libertyFile);
            task.unzipLiberty(libertyFile);
        }
    }

    private String getRuntimeURI(LibertyInfo selected) {
        String propertyName = "webProfile6".equalsIgnoreCase(this.type) ? "uri" : this.type;
        String value = selected.getProperty(propertyName);
        if (value == null) {
            throw new BuildException("Archive type " + propertyName + " is not available for Liberty version " + selected.getVersion());
        }
        return value;
    }
}

