/*
 * Decompiled with CFR 0.152.
 */
package net.wasdev.wlp.ant.install;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.wasdev.wlp.ant.install.InstallLibertyTask;
import net.wasdev.wlp.ant.install.InstallUtils;
import net.wasdev.wlp.ant.install.Installer;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.BuildException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OpenLibertyInstaller
implements Installer {
    private String version;
    private String type;

    @Override
    public void install(InstallLibertyTask task) throws Exception {
        task.log("Installing from Open Liberty repository...");
        String baseUrl = "https://public.dhe.ibm.com/ibmdl/export/pub/software/openliberty/runtime/release/";
        URL versionInfoUrl = new URL(baseUrl + "info.json");
        File cacheDir = new File(task.getCacheDir());
        InstallUtils.createDirectory(cacheDir);
        File versionInfoFile = new File(cacheDir, "openliberty-versions.json");
        task.downloadFile(versionInfoUrl, versionInfoFile);
        FileInputStream versionInfoIs = new FileInputStream(versionInfoFile);
        String versionInfoTxt = IOUtils.toString((InputStream)versionInfoIs, (Charset)StandardCharsets.UTF_8);
        JSONObject versionInfoJson = new JSONObject(versionInfoTxt);
        List versions = versionInfoJson.getJSONArray("versions").toList();
        if (this.version != null && !this.version.isEmpty()) {
            if (!versions.contains(this.version.trim())) {
                throw new BuildException("Runtime version " + this.version + " was not found in the Open Liberty repository.");
            }
        } else {
            this.version = String.valueOf(versions.get(versions.size() - 1));
        }
        task.log("Using runtime version: " + this.version);
        String versionUrl = baseUrl + this.version + "/";
        URL runtimeInfoUrl = new URL(versionUrl + "info.json");
        File runtimeInfoFile = new File(cacheDir, this.version + ".json");
        task.downloadFile(runtimeInfoUrl, runtimeInfoFile);
        FileInputStream runtimeInfoIs = new FileInputStream(runtimeInfoFile);
        String runtimeInfoTxt = IOUtils.toString((InputStream)runtimeInfoIs, (Charset)StandardCharsets.UTF_8);
        JSONObject runtimeInfoJson = new JSONObject(runtimeInfoTxt);
        String runtimeUrlString = null;
        if (this.type == null || this.type.isEmpty()) {
            runtimeUrlString = versionUrl + runtimeInfoJson.getString("driver_location");
        } else {
            try {
                JSONArray packageLocations = runtimeInfoJson.getJSONArray("package_locations");
                for (Object p : packageLocations) {
                    String packageName = String.valueOf(p);
                    if (!packageName.contains(this.type)) continue;
                    runtimeUrlString = versionUrl + packageName;
                    break;
                }
            }
            catch (JSONException e) {
                throw new BuildException("The specified version only contains the default runtime. Remove the \"type\" parameter and try again.", (Throwable)e);
            }
        }
        if (runtimeUrlString == null || runtimeUrlString.isEmpty()) {
            throw new BuildException("Unable to resolve Open Liberty runtime URL.");
        }
        task.setRuntimeUrl(runtimeUrlString);
        File versionCacheDir = new File(task.getCacheDir(), this.version);
        InstallUtils.createDirectory(versionCacheDir);
        URL runtimeUrl = new URL(runtimeUrlString);
        File runtimeFile = new File(versionCacheDir, InstallUtils.getFile(runtimeUrl));
        task.downloadFile(runtimeUrl, runtimeFile);
        if (runtimeUrlString.endsWith(".jar")) {
            task.installLiberty(runtimeFile);
        } else if (runtimeUrlString.endsWith(".zip")) {
            task.unzipLiberty(runtimeFile);
        } else {
            throw new BuildException("Invalid runtime extension.");
        }
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }
}

